/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.listeners;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import simplepets.brainsynder.api.event.user.PetRenameEvent;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.libs.bslib.utils.AdvString;
import simplepets.brainsynder.libs.bslib.utils.Colorize;

public class PetEventListener
implements Listener {
    @EventHandler
    public void onRename(PetRenameEvent event) {
        String name = event.getName();
        if (name == null) {
            return;
        }
        Player player = event.getUser().getPlayer();
        if (ConfigOption.INSTANCE.RENAME_TRIM.getValue().booleanValue()) {
            name = name.trim();
        }
        if (player.hasPermission("pet.name.bypass")) {
            return;
        }
        String rawPattern = ConfigOption.INSTANCE.RENAME_BLOCKED_PATTERN.getValue();
        if (rawPattern != null && !rawPattern.isEmpty() && event.getName().matches(rawPattern)) {
            name = null;
        }
        if (name == null) {
            event.setName(name);
            return;
        }
        List<String> blockedWords = ConfigOption.INSTANCE.RENAME_BLOCKED_WORDS.getValue();
        if (!blockedWords.isEmpty()) {
            for (String word : blockedWords) {
                boolean ignoreCase = word.startsWith("^");
                if (ignoreCase) {
                    word = word.replaceFirst("\\^", "");
                }
                if (word.startsWith("(") && word.endsWith(")")) {
                    if (ignoreCase && name.toLowerCase().contains(AdvString.between("(", ")", word).toLowerCase())) {
                        event.setCancelled(true);
                        return;
                    }
                    if (name.contains(AdvString.between("(", ")", word))) {
                        event.setCancelled(true);
                        return;
                    }
                }
                if (ignoreCase && name.toLowerCase().contains(word.toLowerCase())) {
                    event.setCancelled(true);
                    return;
                }
                if (!name.contains(word)) continue;
                event.setCancelled(true);
                return;
            }
        }
        name = Colorize.translateBungeeHex(name);
        if (ConfigOption.INSTANCE.RENAME_COLOR_ENABLED.getValue().booleanValue()) {
            if (!player.hasPermission("pet.name.color.hex") || !ConfigOption.INSTANCE.RENAME_COLOR_HEX.getValue().booleanValue()) {
                name = this.removeHexColor(name).replace('&', '\u00a7');
            }
            if (!player.hasPermission("pet.name.color")) {
                name = ChatColor.stripColor((String)name);
            }
        }
        if (ConfigOption.INSTANCE.RENAME_LIMIT_CHARS_ENABLED.getValue().booleanValue()) {
            int limit = ConfigOption.INSTANCE.RENAME_LIMIT_CHARS_NUMBER.getValue();
            if (name.length() > limit) {
                name = name.substring(0, limit);
            }
        }
        event.setName(name);
    }

    private String removeHexColor(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        text = text.replace('\u00a7', '&');
        Pattern word = Pattern.compile("&x");
        Matcher matcher = word.matcher(text);
        char[] chars = text.toCharArray();
        while (matcher.find()) {
            StringBuilder builder = new StringBuilder();
            int start = matcher.start();
            int end = start + 14;
            if (end > text.length()) continue;
            for (int i = start; i < end; ++i) {
                builder.append(chars[i]);
            }
            String hex = builder.toString();
            hex = hex.replace("&x", "").replace("&", "");
            text = text.replace(builder.toString(), "");
        }
        return text;
    }
}

