/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import simplepets.brainsynder.libs.bslib.json.JsonArray;
import simplepets.brainsynder.libs.bslib.json.JsonObject;

public class TaskTimer {
    private static final LinkedHashMap<String, JsonArray> STORAGE = new LinkedHashMap();
    private static final LinkedHashMap<String, LinkedList<Record>> STORED_TIME = new LinkedHashMap();
    private final String CLASS_NAME;
    private String previousName = "";

    public TaskTimer(Object instance) {
        this(instance, "");
    }

    public TaskTimer(Object instance, String addition) {
        Class clazz = instance.getClass();
        if (instance instanceof Class) {
            clazz = (Class)instance;
        }
        this.CLASS_NAME = clazz.getSimpleName() + (String)(addition.isEmpty() ? "" : " - " + addition);
        STORED_TIME.put(this.CLASS_NAME, new LinkedList());
    }

    public void start() {
        if (this.previousName.equals("start") || this.previousName.equals("break")) {
            return;
        }
        this.label("start");
    }

    public void label(String name) {
        LinkedList<Record> records = STORED_TIME.get(this.CLASS_NAME);
        if (records.isEmpty() && !name.equals("start")) {
            throw new RuntimeException("The TaskTimer instance for '" + this.CLASS_NAME + "' was not started please run the TaskTimer#start() method first");
        }
        this.previousName = name;
        records.addLast(new Record(name, System.nanoTime()));
        STORED_TIME.put(this.CLASS_NAME, records);
    }

    public void clearTaskTimer() {
        STORAGE.remove(this.CLASS_NAME);
        STORED_TIME.put(this.CLASS_NAME, new LinkedList());
    }

    public void newStart() {
        this.label("break");
    }

    public JsonArray stop() {
        return this.stop("end");
    }

    public JsonArray stop(String label) {
        if (this.previousName.equals(label)) {
            return STORAGE.get(this.CLASS_NAME);
        }
        this.label(label);
        JsonArray array = new JsonArray();
        LinkedList<Record> records = STORED_TIME.get(this.CLASS_NAME);
        DecimalFormat decimalFormat = new DecimalFormat("#0.000", DecimalFormatSymbols.getInstance(Locale.US));
        long previous = 0L;
        while (records.peekFirst() != null) {
            Record record = records.pollFirst();
            if (record.label.equals("start") || record.label.equals("break")) {
                previous = record.time;
                continue;
            }
            long stored = record.time;
            double duration = (double)(stored - previous) / 1000000.0;
            JsonObject value = new JsonObject();
            value.add("name", record.label);
            value.add("duration", duration);
            value.add("formatted", decimalFormat.format(duration) + "ms");
            array.add(value);
        }
        STORAGE.put(this.CLASS_NAME, array);
        return array;
    }

    public static JsonObject fetchAllCompletedTimers() {
        JsonObject json = new JsonObject();
        ArrayList unfinished = new ArrayList();
        STORAGE.forEach(json::add);
        if (STORAGE.size() != STORED_TIME.size()) {
            STORED_TIME.forEach((s, records) -> {
                if (!STORAGE.containsKey(s)) {
                    unfinished.add(s);
                }
            });
        }
        if (!unfinished.isEmpty()) {
            JsonArray array = new JsonArray();
            unfinished.forEach(array::add);
            json.add("unfinished-timers", array);
        }
        return json;
    }

    public static void main(String[] args) throws InterruptedException {
        TaskTimer timer = new TaskTimer(TaskTimer.class);
        timer.start();
        Thread.sleep(500L);
        timer.label("Delay - 500");
        Thread.sleep(150L);
        System.out.println("Output: " + String.valueOf(timer.stop()));
        TaskTimer newTimer = new TaskTimer(TaskTimer.class, "second");
        newTimer.start();
        Thread.sleep(200L);
        newTimer.label("Delay - 200 - 1");
        Thread.sleep(200L);
        newTimer.label("Delay - 200 - 2");
        newTimer.stop();
        System.out.println("Final Output: " + String.valueOf(TaskTimer.fetchAllCompletedTimers()));
    }

    private static class Record {
        private final String label;
        private final long time;

        Record(String label, long time) {
            this.label = label;
            this.time = time;
        }
    }
}

