/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.utils;

import com.google.gson.stream.JsonWriter;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.json.JsonObject;

public final class MessagePart {
    public ChatColor color = null;
    public Color customColor = null;
    public List<ChatColor> styles = null;
    public String clickActionName = null;
    public String clickActionData = null;
    public String hoverActionName = null;
    public String hoverActionData = null;
    public String text;
    public String font = null;

    public MessagePart() {
        this("");
    }

    public MessagePart(String text) {
        this.text = text;
    }

    public JsonObject toJson() {
        JsonObject action;
        JsonObject json = new JsonObject();
        json.add("text", this.text);
        if (this.color != null) {
            json.add("color", this.color.name().toLowerCase());
        } else if (this.customColor != null && ServerVersion.isEqualNew(ServerVersion.v1_16_R1)) {
            json.add("color", MessagePart.toHex(this.customColor.getRed(), this.customColor.getGreen(), this.customColor.getBlue()));
        }
        if (this.font != null) {
            json.add("font", this.font.toLowerCase());
        }
        if (this.styles != null) {
            for (ChatColor style : this.styles) {
                json.add(style.name().toLowerCase(), true);
            }
        }
        if (this.font != null) {
            json.add("font", this.font.toLowerCase());
        }
        if (this.clickActionName != null && this.clickActionData != null) {
            action = new JsonObject();
            action.add("action", this.clickActionName);
            action.add("value", this.clickActionData);
            json.add("clickEvent", action);
        }
        if (this.hoverActionName != null && this.hoverActionData != null) {
            action = new JsonObject();
            action.add("action", this.hoverActionName);
            action.add("value", this.hoverActionData);
            json.add("hoverEvent", action);
        }
        return json;
    }

    public JsonWriter writeJson(JsonWriter json) {
        try {
            json.beginObject().name("text").value(this.text);
            if (this.color != null) {
                json.name("color").value(this.color.name().toLowerCase());
            } else if (this.customColor != null && ServerVersion.isEqualNew(ServerVersion.v1_16_R1)) {
                json.name("color").value(MessagePart.toHex(this.customColor.getRed(), this.customColor.getGreen(), this.customColor.getBlue()));
            }
            if (this.font != null) {
                json.name("font").value(this.font.toLowerCase());
            }
            if (this.styles != null) {
                for (ChatColor style : this.styles) {
                    json.name(style.name().toLowerCase()).value(true);
                }
            }
            if (this.clickActionName != null && this.clickActionData != null) {
                json.name("clickEvent").beginObject().name("action").value(this.clickActionName).name("value").value(this.clickActionData).endObject();
            }
            if (this.hoverActionName != null && this.hoverActionData != null) {
                json.name("hoverEvent").beginObject().name("action").value(this.hoverActionName).name("value").value(this.hoverActionData).endObject();
            }
            return json.endObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return json;
        }
    }

    public static String toHex(int r, int g, int b) {
        return "#" + MessagePart.toBrowserHexValue(r) + MessagePart.toBrowserHexValue(g) + MessagePart.toBrowserHexValue(b);
    }

    private static String toBrowserHexValue(int number) {
        StringBuilder builder = new StringBuilder(Integer.toHexString(number & 0xFF));
        while (builder.length() < 2) {
            builder.append("0");
        }
        return builder.toString().toUpperCase();
    }
}

