/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.utils;

import org.bukkit.Location;
import org.bukkit.entity.Player;

public class DirectionUtils {
    private static String direction(float yaw) {
        int i = Math.round(yaw /= 90.0f);
        switch (i) {
            case -4: 
            case 0: 
            case 4: {
                return "SOUTH";
            }
            case -3: 
            case 1: {
                return "WEST";
            }
            case -2: 
            case 2: {
                return "NORTH";
            }
            case -1: 
            case 3: {
                return "EAST";
            }
        }
        return "";
    }

    public static String getPlayerDirection(Player playerSelf) {
        return DirectionUtils.direction(playerSelf.getLocation().getYaw());
    }

    public static Direction getCardinalDirection(Player player) {
        return DirectionUtils.getCardinalDirection(player.getLocation());
    }

    public static Direction getCardinalDirection(Location location) {
        double rotation = (location.getYaw() - 90.0f) % 360.0f;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        if (0.0 <= rotation && rotation < 67.5) {
            return Direction.NORTH;
        }
        if (67.5 <= rotation && rotation < 112.5) {
            return Direction.EAST;
        }
        if (157.5 <= rotation && rotation < 247.5) {
            return Direction.SOUTH;
        }
        return Direction.WEST;
    }

    public static enum Direction {
        NORTH,
        EAST,
        WEST,
        SOUTH;

    }
}

