/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.utils;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import simplepets.brainsynder.libs.bslib.json.JsonObject;

public class DelayFinder {
    private static final Map<String, Long> startTimeMap = new HashMap<String, Long>();
    private static final LinkedHashMap<String, LinkedHashMap<String, Result>> storedTimeMap = new LinkedHashMap();

    public static void runTask(Object instance, String name, Runnable runnable) {
        DelayFinder.trackDelay(instance, name);
        runnable.run();
        DelayFinder.trackDelay(instance, name);
    }

    public static long trackDelay(Object instance, String taskName) {
        String className = instance.getClass().getSimpleName();
        LinkedHashMap<String, Result> map = storedTimeMap.getOrDefault(className, new LinkedHashMap());
        String key = className + "|" + taskName;
        if (startTimeMap.containsKey(key)) {
            long start = startTimeMap.get(key);
            long end = System.nanoTime();
            final long diff = (end - start) / 1000000L;
            if (diff <= 0L) {
                final long finalDiff = end - start;
                map.put(taskName, new Result(){

                    @Override
                    public String suffix() {
                        return "ns";
                    }

                    @Override
                    public long diff() {
                        return finalDiff;
                    }
                });
            } else {
                map.put(taskName, new Result(){

                    @Override
                    public String suffix() {
                        return "ms";
                    }

                    @Override
                    public long diff() {
                        return diff;
                    }
                });
            }
            startTimeMap.remove(key);
            storedTimeMap.put(className, map);
            return diff;
        }
        map.put(taskName, new Result(){

            @Override
            public String suffix() {
                return "ms";
            }

            @Override
            public long diff() {
                return -1L;
            }
        });
        storedTimeMap.put(className, map);
        startTimeMap.put(key, System.nanoTime());
        return 0L;
    }

    public static JsonObject fetchUnfinished() {
        JsonObject json = new JsonObject();
        startTimeMap.forEach((s, start) -> {
            long end = System.nanoTime();
            long diff = (end - start) / 1000000L;
            String suffix = "ms";
            if (diff <= 0L) {
                diff = end - start;
                suffix = "ns";
            }
            String[] args = s.split("|");
            String className = args[0];
            JsonObject classJson = json.names().contains(className) ? (JsonObject)json.get(className) : new JsonObject();
            String task = args[1];
            classJson.set(task, diff + suffix);
            json.set(className, classJson);
        });
        return json;
    }

    public static JsonObject toJson() {
        JsonObject json = new JsonObject();
        storedTimeMap.forEach((className, map) -> {
            JsonObject object = new JsonObject();
            map.forEach((task, result) -> object.add((String)task, result.diff() + result.suffix()));
            json.set((String)className, object);
        });
        return json;
    }

    private static interface Result {
        public String suffix();

        public long diff();
    }
}

