/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.utils;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;

public class BlockLocation {
    private World world;
    private int x;
    private int y;
    private int z;

    public BlockLocation(World world, int x, int y, int z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockLocation(Location location) {
        this(location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static BlockLocation fromCompound(StorageTagCompound compound) {
        World world = Bukkit.getWorld((String)compound.getString("world"));
        int x = compound.getInteger("x");
        int y = compound.getInteger("y");
        int z = compound.getInteger("z");
        return new BlockLocation(world, x, y, z);
    }

    public StorageTagCompound toCompound() {
        StorageTagCompound compound = new StorageTagCompound();
        compound.setString("world", this.world.getName());
        compound.setInteger("x", this.x);
        compound.setInteger("y", this.y);
        compound.setInteger("z", this.z);
        return compound;
    }

    public Location toLocation() {
        return new Location(this.world, (double)this.x, (double)this.y, (double)this.z);
    }

    public boolean atLocation(BlockLocation location) {
        return location.world.getName().equals(this.world.getName()) && location.x == this.x && location.y == this.y && location.z == this.z;
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }
}

