/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Base64Wrapper {
    private static final char[] map1;
    private static final byte[] map2;

    public static String encodeString(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (Base64Wrapper.isEncoded(string)) {
            return string;
        }
        byte[] bytes = string.getBytes();
        return new String(Base64Wrapper.encode(bytes, 0, bytes.length));
    }

    public static String decodeString(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (!Base64Wrapper.isEncoded(string)) {
            return string;
        }
        char[] chars = string.toCharArray();
        return new String(Base64Wrapper.decode(chars, 0, chars.length));
    }

    public static boolean isEncoded(String string) {
        String pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(string);
        return m.find();
    }

    private static char[] encode(byte[] in, int iOff, int iLen) {
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = iOff;
        int iEnd = iOff + iLen;
        int op = 0;
        while (ip < iEnd) {
            int i0 = in[ip++] & 0xFF;
            int i1 = ip < iEnd ? in[ip++] & 0xFF : 0;
            int i2 = ip < iEnd ? in[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = map1[o0];
            out[op++] = map1[o1];
            out[op] = op < oDataLen ? map1[o2] : 61;
            int n = ++op < oDataLen ? map1[o3] : 61;
            out[op] = n;
            ++op;
        }
        return out;
    }

    private static byte[] decode(char[] in, int iOff, int iLen) {
        if (iLen % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        while (iLen > 0 && in[iOff + iLen - 1] == '=') {
            --iLen;
        }
        int oLen = iLen * 3 / 4;
        byte[] out = new byte[oLen];
        int ip = iOff;
        int iEnd = iOff + iLen;
        int op = 0;
        while (ip < iEnd) {
            int i3;
            char i0 = in[ip++];
            char i1 = in[ip++];
            int i2 = ip < iEnd ? in[ip++] : 65;
            int n = i3 = ip < iEnd ? in[ip++] : 65;
            if (i0 <= '\u007f' && i1 <= '\u007f' && i2 <= 127 && i3 <= 127) {
                byte b0 = map2[i0];
                byte b1 = map2[i1];
                byte b2 = map2[i2];
                byte b3 = map2[i3];
                if (b0 >= 0 && b1 >= 0 && b2 >= 0 && b3 >= 0) {
                    int o0 = b0 << 2 | b1 >>> 4;
                    int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
                    int o2 = (b2 & 3) << 6 | b3;
                    out[op++] = (byte)o0;
                    if (op < oLen) {
                        out[op++] = (byte)o1;
                    }
                    if (op >= oLen) continue;
                    out[op++] = (byte)o2;
                    continue;
                }
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
        }
        return out;
    }

    static {
        int c;
        map1 = new char[64];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            int n = i++;
            int n2 = c;
            Base64Wrapper.map1[n] = n2;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            int n = i++;
            int n3 = c;
            Base64Wrapper.map1[n] = n3;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            int n = i++;
            int n4 = c;
            Base64Wrapper.map1[n] = n4;
        }
        Base64Wrapper.map1[i++] = 43;
        Base64Wrapper.map1[i++] = 47;
        map2 = new byte[128];
        for (i = 0; i < map2.length; ++i) {
            Base64Wrapper.map2[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            Base64Wrapper.map2[Base64Wrapper.map1[i]] = (byte)i;
        }
    }
}

