/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.storage;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ExpireHashMap<K, V> {
    private final Map<K, ExpireEntry> keyLookup = new HashMap<K, ExpireEntry>();
    private final PriorityQueue<ExpireEntry> expireQueue = new PriorityQueue();
    private final Map<K, V> valueView = Maps.transformValues(this.keyLookup, (Function)new Function<ExpireEntry, V>(){

        public V apply(ExpireEntry entry) {
            return entry.value;
        }
    });
    private final Ticker ticker;

    public ExpireHashMap() {
        this(Ticker.systemTicker());
    }

    public ExpireHashMap(Ticker ticker) {
        this.ticker = ticker;
    }

    public V get(K key) {
        this.evict();
        ExpireEntry entry = this.keyLookup.get(key);
        return entry != null ? (V)entry.value : null;
    }

    public V put(K key, V value, long expireDelay, TimeUnit expireUnit) {
        Preconditions.checkNotNull((Object)((Object)expireUnit), (Object)"expireUnit cannot be NULL");
        Preconditions.checkState((expireDelay > 0L ? 1 : 0) != 0, (Object)"expireDelay cannot be equal or less than zero.");
        this.evict();
        ExpireEntry entry = new ExpireEntry(this.ticker.read() + TimeUnit.NANOSECONDS.convert(expireDelay, expireUnit), key, value);
        ExpireEntry previous = this.keyLookup.put(key, entry);
        this.expireQueue.add(entry);
        return previous != null ? (V)previous.value : null;
    }

    public boolean containsKey(K key) {
        this.evict();
        return this.keyLookup.containsKey(key);
    }

    public boolean containsValue(V value) {
        ExpireEntry entry;
        this.evict();
        Iterator<ExpireEntry> var2 = this.keyLookup.values().iterator();
        do {
            if (!var2.hasNext()) {
                return false;
            }
            entry = var2.next();
        } while (!Objects.equal(value, entry.value));
        return true;
    }

    public V removeKey(K key) {
        this.evict();
        ExpireEntry entry = this.keyLookup.remove(key);
        return entry != null ? (V)entry.value : null;
    }

    public int size() {
        this.evict();
        return this.keyLookup.size();
    }

    public Set<K> keySet() {
        this.evict();
        return this.keyLookup.keySet();
    }

    public Collection<V> values() {
        this.evict();
        return this.valueView.values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        this.evict();
        return this.valueView.entrySet();
    }

    public Map<K, V> asMap() {
        this.evict();
        return this.valueView;
    }

    public void collect() {
        this.evict();
        this.expireQueue.clear();
        this.expireQueue.addAll(this.keyLookup.values());
    }

    public void clear() {
        this.keyLookup.clear();
        this.expireQueue.clear();
    }

    protected void evict() {
        long current = this.ticker.read();
        while (this.expireQueue.size() > 0 && this.expireQueue.peek().time <= current) {
            ExpireEntry entry = this.expireQueue.poll();
            if (entry != this.keyLookup.get(entry.key)) continue;
            this.keyLookup.remove(entry.key);
        }
    }

    public String toString() {
        return this.keyLookup.toString();
    }

    private class ExpireEntry
    implements Comparable<ExpireEntry> {
        public final long time;
        public final K key;
        public final V value;

        public ExpireEntry(long time, K key, V value) {
            this.time = time;
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(ExpireEntry o) {
            return Longs.compare((long)this.time, (long)o.time);
        }

        public String toString() {
            return "ExpireEntry [time=" + this.time + ", key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + "]";
        }
    }
}

