/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.reflection;

import java.lang.reflect.Field;

public abstract class FieldAccessor<T> {
    public abstract T get(Object var1);

    public abstract void set(Object var1, T var2);

    public abstract boolean hasField(Object var1);

    public static <T> FieldAccessor<T> getField(Class<?> target, String name, Class<T> fieldType) {
        return FieldAccessor.getField(target, name, fieldType, 0);
    }

    private static <T> FieldAccessor<T> getField(Class<?> target, String name, Class<T> fieldType, int index) {
        while (true) {
            for (final Field field : target.getDeclaredFields()) {
                if (name != null && !field.getName().equals(name) || !fieldType.isAssignableFrom(field.getType()) || index-- > 0) continue;
                field.setAccessible(true);
                return new FieldAccessor<T>(){

                    @Override
                    public T get(Object target) {
                        try {
                            return field.get(target);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException("Cannot access reflection.", e);
                        }
                    }

                    @Override
                    public void set(Object target, T value) {
                        try {
                            field.set(target, value);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException("Cannot access reflection.", e);
                        }
                    }

                    @Override
                    public boolean hasField(Object target) {
                        return field.getDeclaringClass().isAssignableFrom(target.getClass());
                    }
                };
            }
            if (target.getSuperclass() == null) break;
            target = target.getSuperclass();
        }
        throw new IllegalArgumentException("Cannot find field with type " + String.valueOf(fieldType));
    }
}

