/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.particle;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;
import simplepets.brainsynder.libs.bslib.nbt.StorageBase;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagString;
import simplepets.brainsynder.libs.bslib.particle.MissingParticleException;
import simplepets.brainsynder.libs.bslib.particle.Particle;
import simplepets.brainsynder.libs.bslib.particle.data.CustomColor;
import simplepets.brainsynder.libs.bslib.particle.data.NoteColor;

public class ParticleMaker {
    private Particle type;
    private double speed = 0.0;
    private int count = 1;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double offsetZ = 0.0;
    private CustomColor colorOptions = null;
    private Object data = null;
    private boolean colored = false;
    private int repeatAmount = 1;

    public ParticleMaker(Particle type, int count, double radius) {
        this(type, 0.0, count, radius);
    }

    public ParticleMaker(Particle type) {
        this(type, 0.0, 1, 0.0);
    }

    public ParticleMaker(Particle type, double speed, int count, double radius) {
        this(type, speed, count, radius, radius, radius);
    }

    public ParticleMaker(Particle type, int count, double offsetX, double offsetY, double offsetZ) {
        this(type, 0.0, count, offsetX, offsetY, offsetZ);
    }

    @Deprecated
    public ParticleMaker(Particle type, int count, Color color) {
        this(type, 1.0, 0, ParticleMaker.getColor(color.getRed()), ParticleMaker.getColor(color.getGreen()), ParticleMaker.getColor(color.getBlue()));
        this.colored = true;
        this.colorOptions = new CustomColor(color, 1.0f);
        this.repeatAmount = count;
    }

    @Deprecated
    public ParticleMaker(Particle type, Color color) {
        this(type, 1, color);
    }

    public ParticleMaker(Particle type, int count, NoteColor color) {
        this(type, 1.0, 0, color.getValueX(), color.getValueY(), color.getValueZ());
        this.colored = true;
        this.repeatAmount = count;
    }

    public ParticleMaker(Particle type, NoteColor color) {
        this(type, 0, color);
    }

    public ParticleMaker(Particle type, double speed, int count, double offsetX, double offsetY, double offsetZ) {
        if (ServerVersion.getVersion() == ServerVersion.UNKNOWN) {
            try {
                throw new MissingParticleException("This server version is not supported for this particle class.");
            }
            catch (MissingParticleException e) {
                e.printStackTrace();
            }
        }
        this.type = type;
        if (!type.isCompatible()) {
            try {
                throw new MissingParticleException("The particle '" + type.fetchName() + "' is not supported in this version.");
            }
            catch (MissingParticleException e) {
                e.printStackTrace();
            }
        }
        this.speed = speed;
        this.count = count;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
    }

    public ParticleMaker(StorageTagCompound compound) {
        this.type = compound.getEnum("particle", Particle.class, Particle.CRIT);
        this.speed = compound.getDouble("speed", 0.0);
        this.count = compound.getInteger("count", 1);
        if (compound.hasKey("offset")) {
            StorageTagCompound offset = compound.getCompoundTag("offset");
            if (offset.getSize() == 1) {
                throw new MissingParticleException("Offset has to have 3 values (x,y,z)");
            }
            this.offsetX = offset.getDouble("x", 0.0);
            this.offsetY = offset.getDouble("y", 0.0);
            this.offsetZ = offset.getDouble("z", 0.0);
        }
        if (compound.hasKey("color")) {
            this.colorOptions = new CustomColor(compound.getCompoundTag("color"));
        }
        if (compound.hasKey("item")) {
            StorageBase base = compound.getTag("item");
            this.data = base instanceof StorageTagCompound ? ItemBuilder.fromCompound(compound.getCompoundTag("item")).build() : Bukkit.createBlockData((String)((StorageTagString)base).getString());
        }
    }

    public ParticleMaker setType(Particle type) {
        this.type = type;
        return this;
    }

    public ParticleMaker setSpeed(double speed) {
        this.speed = speed;
        return this;
    }

    public ParticleMaker setCount(int count) {
        this.count = count;
        return this;
    }

    public ParticleMaker setColorOptions(CustomColor colorOptions) {
        this.colorOptions = colorOptions;
        return this;
    }

    public ParticleMaker setOffset(double offsetX, double offsetY, double offsetZ) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        return this;
    }

    public ParticleMaker setData(Material material, short itemData) {
        this.data = new ItemStack(material, 1, itemData);
        return this;
    }

    public ParticleMaker setData(Material material) {
        this.setData(material, (short)0);
        return this;
    }

    public ParticleMaker setData(BlockData blockData) {
        this.data = blockData;
        return this;
    }

    public ParticleMaker setData(ItemStack item) {
        this.data = item;
        return this;
    }

    public Particle getType() {
        return this.type;
    }

    public double getSpeed() {
        return this.speed;
    }

    public int getCount() {
        return this.count;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public double getOffsetZ() {
        return this.offsetZ;
    }

    private static float getColor(double value) {
        if (value <= 0.0) {
            value = -1.0;
        }
        return (float)value / 255.0f;
    }

    public void sendToLocation(Location location) {
        location.getWorld().getNearbyEntities(location, 100.0, 100.0, 100.0).forEach(entity -> {
            if (entity instanceof Player) {
                this.sendToPlayer((Player)entity, location);
            }
        });
    }

    public void sendToPlayer(Player player) {
        this.sendToPlayer(player, player.getLocation());
    }

    public void sendToPlayer(Player player, Location location) {
        Object data = null;
        if (this.type == Particle.ITEM || this.type == Particle.BLOCK || this.type == Particle.BLOCK_MARKER) {
            data = this.data == null ? (this.type.name().contains("BLOCK") ? Material.STONE.createBlockData() : new ItemStack(Material.STONE)) : this.data;
        } else if (this.type == Particle.DUST) {
            if (this.colorOptions == null) {
                this.colorOptions = new CustomColor(Color.RED, 1.0f);
            }
            if (ServerVersion.isEqualNew(ServerVersion.v1_13_R1)) {
                data = new Particle.DustOptions(this.colorOptions.getColor(), this.colorOptions.getSize());
            } else {
                this.offsetX = ParticleMaker.getColor(this.colorOptions.getColor().getRed());
                this.offsetY = ParticleMaker.getColor(this.colorOptions.getColor().getGreen());
                this.offsetZ = ParticleMaker.getColor(this.colorOptions.getColor().getBlue());
            }
        } else if (this.type == Particle.INSTANT_EFFECT || this.type == Particle.EFFECT) {
            if (this.colorOptions == null) {
                this.colorOptions = new CustomColor(Color.WHITE, 1.0f);
            }
            if (ServerVersion.isEqualNew(ServerVersion.v1_21_9)) {
                data = new Particle.Spell(this.colorOptions.getColor(), this.colorOptions.getSize());
            }
        }
        if (this.colored) {
            for (int i = 0; i < this.repeatAmount; ++i) {
                player.spawnParticle(org.bukkit.Particle.valueOf((String)this.type.name()), location.getX(), location.getY(), location.getZ(), this.count, this.offsetX, this.offsetY, this.offsetY, this.speed, data);
            }
            return;
        }
        player.spawnParticle(org.bukkit.Particle.valueOf((String)this.type.name()), location.getX(), location.getY(), location.getZ(), this.count, this.offsetX, this.offsetY, this.offsetY, this.speed, data);
    }

    public void sendToPlayers(List<Player> players, Location location) {
        for (Player player : players) {
            this.sendToPlayer(player, location);
        }
    }

    public StorageTagCompound toCompound() {
        StorageTagCompound compound = new StorageTagCompound();
        compound.setEnum("particle", this.type);
        compound.setDouble("speed", this.speed);
        compound.setInteger("count", this.count);
        compound.setTag("offset", new StorageTagCompound().setDouble("x", this.offsetX).setDouble("y", this.offsetY).setDouble("z", this.offsetZ));
        if (this.colorOptions != null) {
            compound.setTag("color", this.colorOptions.toCompound());
        }
        if (this.data != null) {
            if (this.data instanceof BlockData) {
                compound.setString("item", ((BlockData)this.data).getAsString());
            } else {
                compound.setTag("item", ItemBuilder.fromItem((ItemStack)this.data).toCompound());
            }
        }
        return compound;
    }
}

