/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.optional;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import simplepets.brainsynder.libs.bslib.optional.BiOptionalMapper;

public class BiOptional<T, U> {
    @Nullable
    private final T first;
    @Nullable
    private final U second;

    public BiOptional(T first, U second) {
        this.first = first;
        this.second = second;
    }

    public static <T, U> BiOptional<T, U> of(T first) {
        Optional firstOption = Optional.empty();
        if (first != null) {
            firstOption = Optional.of(first);
        }
        return BiOptional.from(firstOption, Optional.empty());
    }

    public static <T, U> BiOptional<T, U> of(T first, U second) {
        Optional firstOption = Optional.empty();
        Optional<Object> secondOption = Optional.empty();
        if (first != null) {
            firstOption = Optional.of(first);
        }
        if (second != null) {
            secondOption = Optional.of(second);
        }
        return BiOptional.from(firstOption, secondOption);
    }

    public static <T, U> BiOptional<T, U> empty() {
        return BiOptional.from(Optional.empty(), Optional.empty());
    }

    public static <T, U> BiOptional<T, U> from(Optional<T> first, Optional<U> second) {
        return new BiOptional<Object, Object>(first.orElse(null), second.orElse(null));
    }

    public Optional<T> first() {
        return Optional.ofNullable(this.first);
    }

    public Optional<U> second() {
        return Optional.ofNullable(this.second);
    }

    public boolean isFirstPresent() {
        return this.first != null;
    }

    public boolean isSecondPresent() {
        return this.second != null;
    }

    public boolean isFirstOnlyPresent() {
        return this.isFirstPresent() && !this.isSecondPresent();
    }

    public boolean isSecondOnlyPresent() {
        return !this.isFirstPresent() && this.isSecondPresent();
    }

    public boolean areBothPresent() {
        return this.isFirstPresent() && this.isSecondPresent();
    }

    public boolean areNonePresent() {
        return !this.isFirstPresent() && !this.isSecondPresent();
    }

    public BiOptional<T, U> ifFirstOnlyPresent(Consumer<? super T> ifFirstOnlyPresent) {
        if (this.isFirstOnlyPresent()) {
            ifFirstOnlyPresent.accept(this.first);
        }
        return this;
    }

    public BiOptional<T, U> ifSecondOnlyPresent(Consumer<? super U> ifSecondOnlyPresent) {
        if (this.isSecondOnlyPresent()) {
            ifSecondOnlyPresent.accept(this.second);
        }
        return this;
    }

    public BiOptional<T, U> ifBothPresent(BiConsumer<? super T, ? super U> ifBothPresent) {
        if (this.areBothPresent()) {
            ifBothPresent.accept(this.first, this.second);
        }
        return this;
    }

    public BiOptional<T, U> ifNonePresent(Runnable ifNonePresent) {
        if (this.areNonePresent()) {
            ifNonePresent.run();
        }
        return this;
    }

    public <X extends Throwable> void ifNonePresentThrow(Supplier<? extends X> throwableProvider) throws X {
        if (this.areNonePresent()) {
            throw (Throwable)throwableProvider.get();
        }
    }

    public <R> BiOptionalMapper<T, U, R> mapper() {
        return new BiOptionalMapper(this);
    }
}

