/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.nms.key;

import com.google.common.collect.Lists;
import com.google.gson.stream.JsonWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import simplepets.brainsynder.libs.bslib.json.JsonArray;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nms.Tellraw;
import simplepets.brainsynder.libs.bslib.utils.Colorize;
import simplepets.brainsynder.libs.bslib.utils.MessagePart;

public class BaseTellrawMessage
extends Tellraw {
    private List<MessagePart> messageParts = new ArrayList<MessagePart>();
    private String jsonString = null;
    private boolean dirty = false;

    public BaseTellrawMessage fromLegacy0(String text) {
        if (text == null || text.isEmpty()) {
            throw new NullPointerException("Missing text input");
        }
        BaseTellrawMessage message = new BaseTellrawMessage();
        List<MessagePart> split = this.splitMessageToParts(text);
        message.messageParts = split;
        message.jsonString = BaseTellrawMessage.convertParts2Json(split).toString();
        return message;
    }

    @Override
    public BaseTellrawMessage color(Object obj) {
        this.latest().color = null;
        this.latest().customColor = null;
        if (obj instanceof String) {
            this.latest().customColor = this.hex2Rgb((String)obj);
        } else if (obj instanceof Color) {
            Color color = (Color)obj;
            this.latest().customColor = this.hex2Rgb(MessagePart.toHex(color.getRed(), color.getGreen(), color.getBlue()));
        } else if (obj instanceof org.bukkit.Color) {
            this.latest().customColor = (org.bukkit.Color)obj;
        } else {
            if (obj instanceof net.md_5.bungee.api.ChatColor) {
                net.md_5.bungee.api.ChatColor color = (net.md_5.bungee.api.ChatColor)obj;
                try {
                    Method method = obj.getClass().getMethod("getColor", new Class[0]);
                    return this.color(method.invoke((Object)color, new Object[0]));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    return this.color(ChatColor.valueOf((String)color.name()));
                }
            }
            if (obj instanceof ChatColor) {
                ChatColor color = (ChatColor)obj;
                if (!color.isColor()) {
                    throw new IllegalArgumentException(color.name() + " is not a color");
                }
                this.latest().color = color;
            } else {
                throw new IllegalArgumentException(obj.getClass().getSimpleName() + " is not a valid input.");
            }
        }
        this.dirty = true;
        return this;
    }

    private org.bukkit.Color hex2Rgb(String hex) {
        if (hex.startsWith("#") && hex.length() == 7) {
            int rgb;
            try {
                rgb = Integer.parseInt(hex.substring(1), 16);
            }
            catch (NumberFormatException var7) {
                throw new IllegalArgumentException("Illegal hex string " + hex);
            }
            return org.bukkit.Color.fromRGB((int)rgb);
        }
        return org.bukkit.Color.RED;
    }

    public BaseTellrawMessage font(String font) {
        if (font == null || font.isEmpty()) {
            throw new NullPointerException("font can not be null");
        }
        this.latest().font = font;
        this.dirty = true;
        return this;
    }

    @Override
    public BaseTellrawMessage style(ChatColor ... styles) {
        for (ChatColor style : styles) {
            if (style.isFormat()) continue;
            throw new IllegalArgumentException(style.name() + " is not a style");
        }
        this.latest().styles = Lists.newArrayList((Object[])styles);
        this.dirty = true;
        return this;
    }

    @Override
    public BaseTellrawMessage file(String path) {
        this.onClick("open_file", path);
        return this;
    }

    @Override
    public BaseTellrawMessage link(String url) {
        this.onClick("open_url", url);
        return this;
    }

    @Override
    public BaseTellrawMessage suggest(String command) {
        this.onClick("suggest_command", command);
        return this;
    }

    @Override
    public BaseTellrawMessage command(String command) {
        this.onClick("run_command", command);
        return this;
    }

    public BaseTellrawMessage achievementTooltip(String name) {
        this.onHover("show_achievement", "achievement." + name);
        return this;
    }

    public BaseTellrawMessage itemTooltip(String itemJSON) {
        this.onHover("show_item", itemJSON);
        return this;
    }

    @Override
    public BaseTellrawMessage tooltip(List<String> lines) {
        return this.tooltip(lines.toArray(new String[lines.size()]));
    }

    @Override
    public BaseTellrawMessage tooltip(String ... lines) {
        this.onHover("show_text", this.combineArray(0, "\n", lines));
        return this;
    }

    @Override
    public BaseTellrawMessage then(Object obj) {
        if (obj instanceof MessagePart) {
            this.messageParts.add((MessagePart)obj);
        } else {
            this.messageParts.add(new MessagePart(obj.toString()));
        }
        this.dirty = true;
        return this;
    }

    @Override
    public BaseTellrawMessage removeLastPart() {
        if (this.messageParts.isEmpty()) {
            return this;
        }
        this.messageParts.remove(this.messageParts.size() - 1);
        return this;
    }

    @Override
    public String toJSONString() {
        if (!this.dirty && this.jsonString != null) {
            return this.jsonString;
        }
        StringWriter string = new StringWriter();
        JsonWriter json = new JsonWriter((Writer)string);
        try {
            if (this.messageParts.size() == 1) {
                this.latest().writeJson(json);
            } else {
                json.beginObject().name("text").value("").name("extra").beginArray();
                for (MessagePart part : this.messageParts) {
                    part.writeJson(json);
                }
                json.endArray().endObject();
                json.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.jsonString = string.toString();
        this.dirty = false;
        return this.jsonString;
    }

    @Override
    public void send(CommandSender sender) {
        if (sender instanceof Player) {
            this.send((Player)sender);
            return;
        }
        StringBuilder builder = new StringBuilder();
        this.messageParts.forEach(part -> {
            if (part.color != null) {
                builder.append(part.color);
            }
            if (part.customColor != null) {
                builder.append(Colorize.fetchColor(part.customColor));
            }
            if (part.styles != null && !part.styles.isEmpty()) {
                for (ChatColor style : part.styles) {
                    builder.append(style);
                }
            }
            builder.append(part.text);
        });
        sender.sendMessage(builder.toString());
    }

    @Override
    public void send(Player player) {
        player.spigot().sendMessage(ComponentSerializer.parse((String)this.toJSONString()));
    }

    private MessagePart latest() {
        return this.messageParts.get(this.messageParts.size() - 1);
    }

    private String combineArray(int startIndex, String separator, String ... stringArray) {
        return this.combineArray(startIndex, stringArray.length, separator, stringArray);
    }

    private String combineArray(int startIndex, int endIndex, String separator, String ... stringArray) {
        if (stringArray != null && startIndex < endIndex) {
            StringBuilder builder = new StringBuilder();
            for (int i = startIndex; i < endIndex; ++i) {
                builder.append(Colorize.translateBungeeHex(stringArray[i]));
                builder.append(separator);
            }
            builder.delete(builder.length() - separator.length(), builder.length());
            return builder.toString();
        }
        return "";
    }

    private void onClick(String name, String data) {
        MessagePart latest = this.latest();
        latest.clickActionName = name;
        latest.clickActionData = data;
        this.dirty = true;
    }

    private void onHover(String name, String data) {
        MessagePart latest = this.latest();
        latest.hoverActionName = name;
        latest.hoverActionData = data;
        this.dirty = true;
    }

    public static JsonObject convertParts2Json(List<MessagePart> parts) {
        JsonObject json = new JsonObject();
        json.add("text", "");
        JsonArray extra = new JsonArray();
        for (MessagePart part : parts) {
            extra.add(part.toJson());
        }
        json.add("extra", extra);
        return json;
    }

    private List<MessagePart> splitMessageToParts(String value) {
        ArrayList<MessagePart> parts = new ArrayList<MessagePart>();
        if (value == null || value.isEmpty()) {
            return parts;
        }
        if ((value = value.replace('\u00a7', '&')).contains("&")) {
            String[] args;
            for (String string : args = value.split("&")) {
                if (string == null || string.isEmpty()) continue;
                MessagePart part = new MessagePart();
                if (string.startsWith("#")) {
                    StringBuilder HEX = new StringBuilder();
                    int end = 6;
                    for (int i = -1; i < end; ++i) {
                        HEX.append(string.charAt(i + 1));
                    }
                    part.text = string.replace(HEX.toString(), "");
                    part.customColor = this.hex2Color(HEX.toString());
                } else {
                    ChatColor color = ChatColor.getByChar((char)string.charAt(0));
                    if (color == null) {
                        part.text = "&" + string;
                    } else {
                        part.text = string.replaceFirst(String.valueOf(string.charAt(0)), "");
                        if (color.isFormat()) {
                            if (part.styles == null) {
                                part.styles = Lists.newArrayList();
                            }
                            part.styles.add(color);
                        } else {
                            part.color = color;
                        }
                    }
                }
                parts.add(part);
            }
        } else {
            parts.add(new MessagePart(value));
        }
        return parts;
    }

    private org.bukkit.Color hex2Color(String hex) {
        return org.bukkit.Color.fromRGB((int)Integer.valueOf(hex.substring(1, 3), 16), (int)Integer.valueOf(hex.substring(3, 5), 16), (int)Integer.valueOf(hex.substring(5, 7), 16));
    }
}

