/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.nbt.other;

public class NBTException
extends Exception {
    public static final int CONTEXT_AMOUNT = 10;
    private final String input;
    private final String message;
    private final int cursor;

    public NBTException(String message, String input, int cursor) {
        super(message, null, true, true);
        this.cursor = cursor;
        this.message = message;
        this.input = input;
    }

    @Override
    public String getMessage() {
        Object message = this.message;
        String context = this.getContext();
        if (context != null) {
            message = (String)message + " at position " + this.cursor + ": " + context;
        }
        return message;
    }

    private String getContext() {
        StringBuilder stringbuilder = new StringBuilder();
        int cursor = Math.min(this.input.length(), this.cursor);
        if (cursor > 10) {
            stringbuilder.append("...");
        }
        stringbuilder.append(this.input, Math.max(0, cursor - 10), cursor);
        stringbuilder.append("<--[HERE]");
        return stringbuilder.toString();
    }
}

