/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.nbt;

import simplepets.brainsynder.libs.bslib.nbt.other.NBTException;

public class StringReader {
    private static final char SYNTAX_ESCAPE = '\\';
    private static final char SYNTAX_DOUBLE_QUOTE = '\"';
    private static final char SYNTAX_SINGLE_QUOTE = '\'';
    private final String string;
    private int cursor;

    public StringReader(StringReader other) {
        this.string = other.string;
        this.cursor = other.cursor;
    }

    public StringReader(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public void setCursor(int cursor) {
        this.cursor = cursor;
    }

    public int getRemainingLength() {
        return this.string.length() - this.cursor;
    }

    public int getTotalLength() {
        return this.string.length();
    }

    public int getCursor() {
        return this.cursor;
    }

    public String getRead() {
        return this.string.substring(0, this.cursor);
    }

    public String getRemaining() {
        return this.string.substring(this.cursor);
    }

    public boolean canRead(int length) {
        return this.cursor + length <= this.string.length();
    }

    public boolean canRead() {
        return this.canRead(1);
    }

    public char peek() {
        return this.string.charAt(this.cursor);
    }

    public char peek(int offset) {
        return this.string.charAt(this.cursor + offset);
    }

    public char read() {
        return this.string.charAt(this.cursor++);
    }

    public void skip() {
        ++this.cursor;
    }

    public static boolean isAllowedNumber(char c) {
        return c >= '0' && c <= '9' || c == '.' || c == '-';
    }

    public static boolean isQuotedStringStart(char c) {
        return c == '\"' || c == '\'';
    }

    public void skipWhitespace() {
        while (this.canRead() && Character.isWhitespace(this.peek())) {
            this.skip();
        }
    }

    public void expect(char c) throws NBTException {
        if (!this.canRead() || this.peek() != c) {
            throw new NBTException("Expected '" + c + "'", this.getString(), this.getCursor());
        }
        this.skip();
    }

    NBTException throwError(String s) {
        return new NBTException(s, this.string, this.cursor);
    }

    public String readQuotedString() throws NBTException {
        if (!this.canRead()) {
            return "";
        }
        char next = this.peek();
        if (!StringReader.isQuotedStringStart(next)) {
            throw this.throwError("Expected value");
        }
        this.skip();
        return this.readStringUntil(next);
    }

    public String readString() throws NBTException {
        if (!this.canRead()) {
            return "";
        }
        char next = this.peek();
        if (StringReader.isQuotedStringStart(next)) {
            this.skip();
            return this.readStringUntil(next);
        }
        return this.readUnquotedString();
    }

    public String readStringUntil(char terminator) throws NBTException {
        StringBuilder result = new StringBuilder();
        boolean escaped = false;
        while (this.canRead()) {
            char c = this.read();
            if (escaped) {
                if (c == terminator || c == '\\') {
                    result.append(c);
                    escaped = false;
                    continue;
                }
                this.setCursor(this.getCursor() - 1);
                throw this.throwError("Invalid escape of '" + c + "'");
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == terminator) {
                return result.toString();
            }
            result.append(c);
        }
        throw this.throwError("Expected value");
    }

    public static boolean isAllowedInUnquotedString(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '-' || c == '.' || c == '+';
    }

    public String readUnquotedString() {
        int start = this.cursor;
        while (this.canRead() && StringReader.isAllowedInUnquotedString(this.peek())) {
            this.skip();
        }
        return this.string.substring(start, this.cursor);
    }
}

