/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.nbt;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.NBTContainer;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.NBTItem;
import simplepets.brainsynder.libs.bslib.json.JsonArray;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.json.JsonValue;
import simplepets.brainsynder.libs.bslib.nbt.JsonToNBT;
import simplepets.brainsynder.libs.bslib.nbt.StorageBase;
import simplepets.brainsynder.libs.bslib.nbt.StoragePrimitive;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagByteArray;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagIntArray;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagList;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagLongArray;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagString;
import simplepets.brainsynder.libs.bslib.nbt.other.IStorageList;
import simplepets.brainsynder.libs.bslib.nbt.other.NBTException;
import simplepets.brainsynder.libs.bslib.reflection.Reflection;

public class StorageTagTools {
    private static final Class<?> nbtTag;
    private static final Class<?> craftStack;
    private static final Class<?> stackClass;
    private static final Constructor newKey;
    private static final Method asCopy;
    private static final Method parseString;

    public static ItemStack toItemStack(StorageTagCompound compound) {
        if (!compound.hasKey("id")) {
            return new ItemStack(Material.AIR);
        }
        return NBTItem.convertNBTtoItem(new NBTContainer(compound.toString()));
    }

    public static StorageTagCompound fromItemStack(ItemStack item) {
        String json = NBTItem.convertItemtoNBT(item).toString();
        StorageTagCompound compound = new StorageTagCompound();
        try {
            compound = JsonToNBT.getTagFromJson(json);
        }
        catch (NBTException e) {
            e.printStackTrace();
        }
        return compound;
    }

    public PotionEffect toPotionEffect(StorageTagCompound compound) {
        return new PotionEffect(PotionEffectType.getByName((String)compound.getString("type", "SPEED")), compound.getInteger("duration"), compound.getInteger("amplifier"), compound.getBoolean("isAmbient"), compound.getBoolean("hasParticles"), compound.getBoolean("hasIcon"));
    }

    public static StorageTagCompound fromPotionEffect(PotionEffect effect) {
        StorageTagCompound compound = new StorageTagCompound();
        compound.setString("type", effect.getType().getName());
        compound.setInteger("amplifier", effect.getAmplifier());
        compound.setInteger("duration", effect.getDuration());
        compound.setBoolean("isAmbient", effect.isAmbient());
        compound.setBoolean("hasParticles", effect.hasParticles());
        compound.setBoolean("hasIcon", effect.hasIcon());
        return compound;
    }

    public static JsonObject toJsonObject(StorageTagCompound compound) {
        JsonObject json = new JsonObject();
        compound.getKeySet().forEach(key -> {
            StorageBase base = compound.getTag((String)key);
            if (compound.isBoolean((String)key)) {
                json.add((String)key, compound.getBoolean((String)key));
            } else if (base instanceof StoragePrimitive) {
                json.add((String)key, ((StoragePrimitive)base).getInt());
            } else if (base instanceof IStorageList) {
                JsonArray array = new JsonArray();
                Object list = ((IStorageList)((Object)base)).getList();
                if (list instanceof byte[]) {
                    for (byte v : (byte[])list) {
                        array.add(v + "b");
                    }
                } else if (list instanceof int[]) {
                    for (int v : (int[])list) {
                        array.add(v);
                    }
                } else if (list instanceof long[]) {
                    for (long v : (long[])list) {
                        array.add(v + "l");
                    }
                } else if (list instanceof List) {
                    ((List)list).forEach(string -> array.add(String.valueOf(string).replace("\"", "")));
                }
                json.add((String)key, array);
            } else if (base instanceof StorageTagCompound) {
                json.add((String)key, StorageTagTools.toJsonObject((StorageTagCompound)base));
            } else if (base instanceof StorageTagString) {
                json.add((String)key, base.getString());
            }
        });
        return json;
    }

    public static StorageTagCompound fromJsonObject(JsonObject json) {
        StorageTagCompound compound = new StorageTagCompound();
        json.names().forEach(key -> {
            JsonValue value = json.get((String)key);
            if (value.isNumber()) {
                compound.setInteger((String)key, value.asInt());
            } else if (value.isBoolean()) {
                compound.setBoolean((String)key, value.asBoolean());
            } else if (value.isString()) {
                compound.setString((String)key, value.asString());
            } else if (value.isArray()) {
                JsonArray array = value.asArray();
                ArrayList<Byte> bytes = new ArrayList<Byte>();
                ArrayList<Integer> ints = new ArrayList<Integer>();
                ArrayList<Long> longs = new ArrayList<Long>();
                StorageTagList list = new StorageTagList();
                array.values().forEach(jsonValue -> {
                    if (jsonValue.isString()) {
                        String string = jsonValue.asString();
                        if (string.endsWith("l")) {
                            try {
                                longs.add(Long.parseLong(string.replace("l", "")));
                            }
                            catch (NumberFormatException e) {
                                list.appendTag(new StorageTagString(string));
                            }
                        } else if (string.endsWith("b")) {
                            try {
                                bytes.add(Byte.parseByte(string.replace("b", "")));
                            }
                            catch (NumberFormatException e) {
                                list.appendTag(new StorageTagString(string));
                            }
                        } else {
                            try {
                                ints.add(Integer.parseInt(string));
                            }
                            catch (NumberFormatException e) {
                                list.appendTag(new StorageTagString(string));
                            }
                        }
                    }
                    if (jsonValue.isNumber()) {
                        ints.add(jsonValue.asInt());
                    }
                });
                if (!bytes.isEmpty()) {
                    compound.setTag((String)key, new StorageTagByteArray(bytes));
                } else if (!ints.isEmpty()) {
                    compound.setTag((String)key, new StorageTagIntArray(ints));
                } else if (!longs.isEmpty()) {
                    compound.setTag((String)key, new StorageTagLongArray(longs));
                } else {
                    compound.setTag((String)key, list);
                }
            } else if (value.isObject()) {
                compound.setTag((String)key, StorageTagTools.fromJsonObject(value.asObject()));
            }
        });
        return compound;
    }

    public static <T> T toNBTTag(StorageTagCompound compound) {
        return (T)Reflection.invoke(parseString, null, compound.toString());
    }

    private static Object asNMSCopy(ItemStack stack) {
        return Reflection.invoke(asCopy, null, stack);
    }

    private static Object newNBTTag(Class<?> nbtTag) {
        return Reflection.initiateClass(nbtTag);
    }

    private static Object newMCKey(String key) {
        return Reflection.initiateClass(newKey, key);
    }

    static {
        Class<?> parser = Reflection.getNmsClass("MojangsonParser", "nbt");
        parseString = Reflection.getMethod(parser, new String[]{"parse", "a"}, String.class);
        craftStack = Reflection.getCBCClass("inventory.CraftItemStack");
        Class<?> keyClass = Reflection.getNmsClass("MinecraftKey", "resources");
        newKey = Reflection.getConstructor(keyClass, String.class);
        nbtTag = Reflection.getNmsClass("NBTTagCompound", "nbt");
        stackClass = Reflection.getNmsClass("ItemStack", "world.item");
        asCopy = Reflection.getMethod(craftStack, "asNMSCopy", ItemStack.class);
    }
}

