/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import simplepets.brainsynder.libs.bslib.math.MathUtils;
import simplepets.brainsynder.libs.bslib.nbt.StoragePrimitive;
import simplepets.brainsynder.libs.bslib.nbt.other.NBTSizeTracker;

public class StorageTagFloat
extends StoragePrimitive {
    private float data;

    StorageTagFloat() {
    }

    public StorageTagFloat(float data) {
        this.data = data;
    }

    @Override
    void write(DataOutput output) throws IOException {
        output.writeFloat(this.data);
    }

    @Override
    void read(DataInput input, int depth, NBTSizeTracker sizeTracker) throws IOException {
        sizeTracker.read(96L);
        this.data = input.readFloat();
    }

    @Override
    public byte getId() {
        return 5;
    }

    @Override
    public String toString() {
        return this.data + "f";
    }

    @Override
    public StorageTagFloat copy() {
        return new StorageTagFloat(this.data);
    }

    @Override
    public boolean equals(Object instance) {
        return super.equals(instance) && this.data == ((StorageTagFloat)instance).data;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Float.floatToIntBits(this.data);
    }

    @Override
    public long getLong() {
        return (long)this.data;
    }

    @Override
    public int getInt() {
        return MathUtils.floor(this.data);
    }

    @Override
    public short getShort() {
        return (short)(MathUtils.floor(this.data) & 0xFFFF);
    }

    @Override
    public byte getByte() {
        return (byte)(MathUtils.floor(this.data) & 0xFF);
    }

    @Override
    public double getDouble() {
        return this.data;
    }

    @Override
    public float getFloat() {
        return this.data;
    }
}

