/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import simplepets.brainsynder.libs.bslib.math.MathUtils;
import simplepets.brainsynder.libs.bslib.nbt.StoragePrimitive;
import simplepets.brainsynder.libs.bslib.nbt.other.NBTSizeTracker;

public class StorageTagDouble
extends StoragePrimitive {
    private double data;

    StorageTagDouble() {
    }

    public StorageTagDouble(double data) {
        this.data = data;
    }

    @Override
    void write(DataOutput output) throws IOException {
        output.writeDouble(this.data);
    }

    @Override
    void read(DataInput input, int depth, NBTSizeTracker sizeTracker) throws IOException {
        sizeTracker.read(128L);
        this.data = input.readDouble();
    }

    @Override
    public byte getId() {
        return 6;
    }

    @Override
    public String toString() {
        return this.data + "d";
    }

    @Override
    public StorageTagDouble copy() {
        return new StorageTagDouble(this.data);
    }

    @Override
    public boolean equals(Object instance) {
        return super.equals(instance) && this.data == ((StorageTagDouble)instance).data;
    }

    @Override
    public int hashCode() {
        long i = Double.doubleToLongBits(this.data);
        return super.hashCode() ^ (int)(i ^ i >>> 32);
    }

    @Override
    public long getLong() {
        return (long)Math.floor(this.data);
    }

    @Override
    public int getInt() {
        return MathUtils.floor(this.data);
    }

    @Override
    public short getShort() {
        return (short)(MathUtils.floor(this.data) & 0xFFFF);
    }

    @Override
    public byte getByte() {
        return (byte)(MathUtils.floor(this.data) & 0xFF);
    }

    @Override
    public double getDouble() {
        return this.data;
    }

    @Override
    public float getFloat() {
        return (float)this.data;
    }
}

