/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.nbt;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import simplepets.brainsynder.libs.bslib.nbt.StorageBase;
import simplepets.brainsynder.libs.bslib.nbt.StoragePrimitive;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagByte;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagByteArray;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagDouble;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagFloat;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagInt;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagIntArray;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagList;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagLong;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagLongArray;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagShort;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagString;
import simplepets.brainsynder.libs.bslib.nbt.StringReader;
import simplepets.brainsynder.libs.bslib.nbt.other.NBTException;

public class JsonToNBT {
    private static final Pattern DOUBLE_PATTERN2 = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern FLOAT_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern BYTE_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern LONG_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern SHORT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern INT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    private final StringReader reader;

    private JsonToNBT(StringReader reader) {
        this.reader = reader;
    }

    public static JsonToNBT parse(String string) {
        return new JsonToNBT(new StringReader(string));
    }

    public static StorageTagCompound getTagFromJson(String string) throws NBTException {
        return JsonToNBT.parse(string).toCompound();
    }

    public StorageTagCompound toCompound() throws NBTException {
        StorageTagCompound compoundTag = this.parseCompoundTag();
        this.reader.skipWhitespace();
        if (this.reader.canRead()) {
            throw this.reader.throwError("Trailing data found");
        }
        return compoundTag;
    }

    public StorageTagList toList() throws NBTException {
        StorageTagList compoundTag = (StorageTagList)this.list();
        this.reader.skipWhitespace();
        if (this.reader.canRead()) {
            throw this.reader.throwError("Trailing data found");
        }
        return compoundTag;
    }

    private String readString() throws NBTException {
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw this.reader.throwError("Expected key");
        }
        return this.reader.readString();
    }

    protected StorageBase parseTagPrimitive() throws NBTException {
        this.reader.skipWhitespace();
        int i = this.reader.getCursor();
        if (StringReader.isQuotedStringStart(this.reader.peek())) {
            return new StorageTagString(this.reader.readQuotedString());
        }
        String string = this.reader.readUnquotedString();
        if (string.isEmpty()) {
            this.reader.setCursor(i);
            throw this.reader.throwError("Expected value");
        }
        return this.parsePrimitive(string);
    }

    private StorageBase parsePrimitive(String value) {
        try {
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                return new StorageTagByte((byte)(Boolean.getBoolean(value) ? 1 : 0));
            }
            if (FLOAT_PATTERN.matcher(value).matches()) {
                return new StorageTagFloat(Float.parseFloat(value.substring(0, value.length() - 1)));
            }
            if (BYTE_PATTERN.matcher(value).matches()) {
                return new StorageTagByte(Byte.parseByte(value.substring(0, value.length() - 1)));
            }
            if (LONG_PATTERN.matcher(value).matches()) {
                return new StorageTagLong(Long.parseLong(value.substring(0, value.length() - 1)));
            }
            if (SHORT_PATTERN.matcher(value).matches()) {
                return new StorageTagShort(Short.parseShort(value.substring(0, value.length() - 1)));
            }
            if (INT_PATTERN.matcher(value).matches()) {
                return new StorageTagInt(Integer.parseInt(value));
            }
            if (DOUBLE_PATTERN.matcher(value).matches()) {
                return new StorageTagDouble(Double.parseDouble(value.substring(0, value.length() - 1)));
            }
            if (DOUBLE_PATTERN2.matcher(value).matches()) {
                return new StorageTagDouble(Double.parseDouble(value));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new StorageTagString(value);
    }

    private StorageBase parseTag() throws NBTException {
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw this.reader.throwError("Expected value");
        }
        char c = this.reader.peek();
        if (c == '{') {
            return this.parseCompoundTag();
        }
        return c == '[' ? this.parseTagArray() : this.parseTagPrimitive();
    }

    private StorageBase parseTagArray() throws NBTException {
        return this.reader.canRead(3) && !StringReader.isQuotedStringStart(this.reader.peek(1)) && this.reader.peek(2) == ';' ? this.arrays() : this.list();
    }

    private StorageTagCompound parseCompoundTag() throws NBTException {
        this.expect('{');
        StorageTagCompound compoundTag = new StorageTagCompound();
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != '}') {
            int i = this.reader.getCursor();
            String string = this.readString();
            if (string.isEmpty()) {
                this.reader.setCursor(i);
                throw this.reader.throwError("Expected non-empty key");
            }
            this.expect(':');
            compoundTag.setTag(string, this.parseTag());
            if (!this.readComma()) break;
            if (this.reader.canRead()) continue;
            throw this.reader.throwError("Expected key");
        }
        this.expect('}');
        return compoundTag;
    }

    private StorageBase list() throws NBTException {
        this.expect('[');
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw this.reader.throwError("Expected value");
        }
        StorageTagList listTag = new StorageTagList();
        byte reader = -1;
        while (this.reader.peek() != ']') {
            int i = this.reader.getCursor();
            StorageBase tag = this.parseTag();
            byte reader2 = tag.getId();
            if (reader == -1) {
                reader = reader2;
            } else if (reader2 != reader) {
                this.reader.setCursor(i);
                throw this.reader.throwError("Unable to insert " + StorageBase.getName(reader2) + " into ListTag of type " + StorageBase.getName(reader));
            }
            listTag.appendTag(tag);
            if (!this.readComma()) break;
            if (this.reader.canRead()) continue;
            throw this.reader.throwError("Expected value");
        }
        this.expect(']');
        return listTag;
    }

    private StorageBase arrays() throws NBTException {
        this.expect('[');
        int i = this.reader.getCursor();
        char c = this.reader.read();
        this.reader.read();
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw this.reader.throwError("Expected value");
        }
        if (c == 'B') {
            return new StorageTagByteArray(this.readArray((byte)7, (byte)1));
        }
        if (c == 'L') {
            return new StorageTagLongArray(this.readArray((byte)12, (byte)4));
        }
        if (c == 'I') {
            return new StorageTagIntArray(this.readArray((byte)11, (byte)3));
        }
        this.reader.setCursor(i);
        throw this.reader.throwError("Invalid array type '" + c + "' found");
    }

    private <T extends Number> List<T> readArray(byte b, byte b1) throws NBTException {
        ArrayList list = Lists.newArrayList();
        while (this.reader.peek() != ']') {
            int i = this.reader.getCursor();
            StorageBase tag = this.parseTag();
            byte reader = tag.getId();
            if (reader != b1) {
                throw this.reader.throwError("Unable to insert " + StorageBase.getName(i) + " into " + StorageBase.getName(b));
            }
            if (b1 == 1) {
                list.add(((StoragePrimitive)tag).getByte());
            } else if (b1 == 4) {
                list.add(((StoragePrimitive)tag).getLong());
            } else {
                list.add(((StoragePrimitive)tag).getInt());
            }
            if (!this.readComma()) break;
            if (this.reader.canRead()) continue;
            throw this.reader.throwError("Expected value");
        }
        this.expect(']');
        return list;
    }

    private void expect(char c) throws NBTException {
        this.reader.skipWhitespace();
        this.reader.expect(c);
    }

    private boolean checkChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '-' || c == '.' || c == '+';
    }

    private boolean readComma() {
        this.reader.skipWhitespace();
        if (this.reader.canRead() && this.reader.peek() == ',') {
            this.reader.skip();
            this.reader.skipWhitespace();
            return true;
        }
        return false;
    }
}

