/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.math;

import java.text.DecimalFormat;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import simplepets.brainsynder.libs.bslib.math.TrigMath;

public class MathUtils {
    public static final float nanoToSec = 1.0E-9f;
    public static final float FLOAT_ROUNDING_ERROR = 1.0E-6f;
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float SQRT_3 = 1.7320508f;
    public static final float E = (float)Math.E;
    private static final int SIN_BITS = 14;
    private static final int SIN_MASK = 16383;
    private static final int SIN_COUNT = 16384;
    private static final float radFull = (float)Math.PI * 2;
    private static final float degFull = 360.0f;
    private static final float radToIndex = 2607.5945f;
    private static final float degToIndex = 45.511112f;
    public static final float radiansToDegrees = 57.295776f;
    public static final float radDeg = 57.295776f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static final float degRad = (float)Math.PI / 180;
    private static final int ATAN2_BITS = 7;
    private static final int ATAN2_BITS2 = 14;
    private static final int ATAN2_MASK = 16383;
    private static final int ATAN2_COUNT = 16384;
    static final int ATAN2_DIM = (int)Math.sqrt(16384.0);
    private static final float INV_ATAN2_DIM_MINUS_1;
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double BIG_ENOUGH_FLOOR = 16384.0;
    private static final double CEIL = 0.9999999;
    private static final double BIG_ENOUGH_CEIL = 16384.999999999996;
    private static final double BIG_ENOUGH_ROUND = 16384.5;
    private static final int CHUNK_BITS = 4;
    private static final int CHUNK_VALUES = 16;
    public static final float DEGTORAD = (float)Math.PI / 180;
    public static final float RADTODEG = 57.29578f;
    public static final double HALFROOTOFTWO = 0.707106781;
    private static Random random;

    public static double trim(int degree, double d) {
        StringBuilder format = new StringBuilder("#.#");
        for (int twoDForm = 1; twoDForm < degree; ++twoDForm) {
            format.append("#");
        }
        DecimalFormat var5 = new DecimalFormat(format.toString());
        return Double.valueOf(var5.format(d));
    }

    public static int getAngleDifference(int angle1, int angle2) {
        return Math.abs(MathUtils.wrapAngle(angle1 - angle2));
    }

    public static int wrapAngle(int angle) {
        int wrappedAngle;
        for (wrappedAngle = angle; wrappedAngle <= -180; wrappedAngle += 360) {
        }
        while (wrappedAngle > 180) {
            wrappedAngle -= 360;
        }
        return wrappedAngle;
    }

    public static float wrapAngle(float angle) {
        float wrappedAngle;
        for (wrappedAngle = angle; wrappedAngle <= -180.0f; wrappedAngle += 360.0f) {
        }
        while (wrappedAngle > 180.0f) {
            wrappedAngle -= 360.0f;
        }
        return wrappedAngle;
    }

    public static double normalize(double x, double z, double reqx, double reqz) {
        return Math.sqrt(MathUtils.lengthSquared(reqx, reqz) / MathUtils.lengthSquared(x, z));
    }

    public static float getLookAtYaw(Entity loc, Entity lookat) {
        return MathUtils.getLookAtYaw(loc.getLocation(), lookat.getLocation());
    }

    public static float getLookAtYaw(Block loc, Block lookat) {
        return MathUtils.getLookAtYaw(loc.getLocation(), lookat.getLocation());
    }

    public static float getLookAtYaw(Location loc, Location lookat) {
        return MathUtils.getLookAtYaw(lookat.getX() - loc.getX(), lookat.getZ() - loc.getZ());
    }

    public static float getLookAtYaw(Vector motion) {
        return MathUtils.getLookAtYaw(motion.getX(), motion.getZ());
    }

    public static float getLookAtYaw(double dx, double dz) {
        return MathUtils.atan2(dz, dx) - 180.0f;
    }

    public static double lengthSquared(double ... values) {
        double rval = 0.0;
        for (double value : values) {
            rval += value * value;
        }
        return rval;
    }

    public static double length(double ... values) {
        return Math.sqrt(MathUtils.lengthSquared(values));
    }

    public static float getLookAtPitch(double dX, double dY, double dZ) {
        return MathUtils.getLookAtPitch(dY, MathUtils.length(dX, dZ));
    }

    public static float getLookAtPitch(double dY, double dXZ) {
        return -MathUtils.atan(dY / dXZ);
    }

    public static float atan(double value) {
        return 57.29578f * (float)TrigMath.atan(value);
    }

    public static float atan2(double y, double x) {
        return 57.29578f * (float)TrigMath.atan2(y, x);
    }

    public static int floor(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    public static int ceil(double value) {
        return -MathUtils.floor(-value);
    }

    public static Location move(Location loc, Vector offset) {
        return MathUtils.move(loc, offset.getX(), offset.getY(), offset.getZ());
    }

    public static Location move(Location loc, double dx, double dy, double dz) {
        Vector off = MathUtils.rotate(loc.getYaw(), loc.getPitch(), dx, dy, dz);
        double x = loc.getX() + off.getX();
        double y = loc.getY() + off.getY();
        double z = loc.getZ() + off.getZ();
        return new Location(loc.getWorld(), x, y, z, loc.getYaw(), loc.getPitch());
    }

    public static Vector rotate(float yaw, float pitch, Vector vector) {
        return MathUtils.rotate(yaw, pitch, vector.getX(), vector.getY(), vector.getZ());
    }

    public static Vector rotate(float yaw, float pitch, double x, double y, double z) {
        float angle = yaw * ((float)Math.PI / 180);
        double sinyaw = Math.sin(angle);
        double cosyaw = Math.cos(angle);
        angle = pitch * ((float)Math.PI / 180);
        double sinpitch = Math.sin(angle);
        double cospitch = Math.cos(angle);
        Vector vector = new Vector();
        vector.setX(x * sinyaw - y * cosyaw * sinpitch - z * cosyaw * cospitch);
        vector.setY(y * cospitch - z * sinpitch);
        vector.setZ(-(x * cosyaw) - y * sinyaw * sinpitch - z * sinyaw * cospitch);
        return vector;
    }

    public static double round(double value, int decimals) {
        double p = Math.pow(10.0, decimals);
        return (double)Math.round(value * p) / p;
    }

    public static double fixNaN(double value) {
        return MathUtils.fixNaN(value, 0.0);
    }

    public static double fixNaN(double value, double def) {
        return Double.isNaN(value) ? def : value;
    }

    public static int toChunk(double loc) {
        return MathUtils.floor(loc / 16.0);
    }

    public static int toChunk(int loc) {
        return loc >> 4;
    }

    public static double useOld(double oldvalue, double newvalue, double peruseold) {
        return oldvalue + peruseold * (newvalue - oldvalue);
    }

    public static double lerp(double d1, double d2, double stage) {
        if (Double.isNaN(stage) || stage > 1.0) {
            return d2;
        }
        if (stage < 0.0) {
            return d1;
        }
        return d1 * (1.0 - stage) + d2 * stage;
    }

    public static Vector lerp(Vector vec1, Vector vec2, double stage) {
        Vector newvec = new Vector();
        newvec.setX(MathUtils.lerp(vec1.getX(), vec2.getX(), stage));
        newvec.setY(MathUtils.lerp(vec1.getY(), vec2.getY(), stage));
        newvec.setZ(MathUtils.lerp(vec1.getZ(), vec2.getZ(), stage));
        return newvec;
    }

    public static Location lerp(Location loc1, Location loc2, double stage) {
        Location newloc = new Location(loc1.getWorld(), 0.0, 0.0, 0.0);
        newloc.setX(MathUtils.lerp(loc1.getX(), loc2.getX(), stage));
        newloc.setY(MathUtils.lerp(loc1.getY(), loc2.getY(), stage));
        newloc.setZ(MathUtils.lerp(loc1.getZ(), loc2.getZ(), stage));
        newloc.setYaw((float)MathUtils.lerp(loc1.getYaw(), loc2.getYaw(), stage));
        newloc.setPitch((float)MathUtils.lerp(loc1.getPitch(), loc2.getPitch(), stage));
        return newloc;
    }

    public static boolean isInverted(double value1, double value2) {
        return value1 > 0.0 && value2 < 0.0 || value1 < 0.0 && value2 > 0.0;
    }

    public static Vector getDirection(float yaw, float pitch) {
        Vector vector = new Vector();
        double rotX = (float)Math.PI / 180 * yaw;
        double rotY = (float)Math.PI / 180 * pitch;
        vector.setY(-Math.sin(rotY));
        double h = Math.cos(rotY);
        vector.setX(-h * Math.sin(rotX));
        vector.setZ(h * Math.cos(rotX));
        return vector;
    }

    public static double clamp(double value, double limit) {
        return MathUtils.clamp(value, -limit, limit);
    }

    public static double clamp(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float clamp(float value, float limit) {
        return MathUtils.clamp(value, -limit, limit);
    }

    public static int clamp(int value, int limit) {
        return MathUtils.clamp(value, -limit, limit);
    }

    public static int invert(int value, boolean negative) {
        return negative ? -value : value;
    }

    public static float invert(float value, boolean negative) {
        return negative ? -value : value;
    }

    public static double invert(double value, boolean negative) {
        return negative ? -value : value;
    }

    public static void setVectorLength(Vector vector, double length) {
        MathUtils.setVectorLengthSquared(vector, Math.signum(length) * length * length);
    }

    public static void setVectorLengthSquared(Vector vector, double lengthsquared) {
        double vlength = vector.lengthSquared();
        if (Math.abs(vlength) > 1.0E-4) {
            if (lengthsquared < 0.0) {
                vector.multiply(-Math.sqrt(-lengthsquared / vlength));
            } else {
                vector.multiply(Math.sqrt(lengthsquared / vlength));
            }
        }
    }

    public static float getAngleDifference(float angle1, float angle2) {
        return Math.abs(MathUtils.wrapAngle(angle1 - angle2));
    }

    public static int r(int i) {
        return random.nextInt(i);
    }

    public static double offset2d(Entity a, Entity b) {
        return MathUtils.offset2d(a.getLocation().toVector(), b.getLocation().toVector());
    }

    public static double offset2d(Location a, Location b) {
        return MathUtils.offset2d(a.toVector(), b.toVector());
    }

    public static double offset2d(Vector a, Vector b) {
        a.setY(0);
        b.setY(0);
        return a.subtract(b).length();
    }

    public static float sin(float radians) {
        return Sin.table[(int)(radians * 2607.5945f) & 0x3FFF];
    }

    public static float cos(float radians) {
        return Sin.table[(int)((radians + 1.5707964f) * 2607.5945f) & 0x3FFF];
    }

    public static float sinDeg(float degrees) {
        return Sin.table[(int)(degrees * 45.511112f) & 0x3FFF];
    }

    public static float cosDeg(float degrees) {
        return Sin.table[(int)((degrees + 90.0f) * 45.511112f) & 0x3FFF];
    }

    public static boolean isInteger(Object object) {
        try {
            Integer.parseInt(object.toString());
            return true;
        }
        catch (Exception var2) {
            return false;
        }
    }

    public static boolean isDouble(Object object) {
        try {
            Double.parseDouble(object.toString());
            return true;
        }
        catch (Exception var2) {
            return false;
        }
    }

    public static float atan2(float y, float x) {
        float add;
        float mul;
        if (x < 0.0f) {
            if (y < 0.0f) {
                y = -y;
                mul = 1.0f;
            } else {
                mul = -1.0f;
            }
            x = -x;
            add = (float)(-Math.PI);
        } else {
            if (y < 0.0f) {
                y = -y;
                mul = -1.0f;
            } else {
                mul = 1.0f;
            }
            add = 0.0f;
        }
        float invDiv = 1.0f / ((x < y ? y : x) * INV_ATAN2_DIM_MINUS_1);
        if ((double)invDiv == Double.POSITIVE_INFINITY) {
            return ((float)Math.atan2(y, x) + add) * mul;
        }
        int xi = (int)(x * invDiv);
        int yi = (int)(y * invDiv);
        return (Atan2.table[yi * ATAN2_DIM + xi] + add) * mul;
    }

    public static int random(int range) {
        return random.nextInt(range + 1);
    }

    public static int random(int start, int end) {
        return start + random.nextInt(end - start + 1);
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static boolean randomBoolean(float chance) {
        return MathUtils.random() < chance;
    }

    public static float random() {
        return random.nextFloat();
    }

    public static float random(float range) {
        return random.nextFloat() * range;
    }

    public static float random(float start, float end) {
        return start + random.nextFloat() * (end - start);
    }

    public static int nextPowerOfTwo(int value) {
        if (value == 0) {
            return 1;
        }
        --value;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        return value + 1;
    }

    public static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static int clamp(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static short clamp(short value, short min, short max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float clamp(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static int floor(float x) {
        return (int)((double)x + 16384.0) - 16384;
    }

    public static int floorPositive(float x) {
        return (int)x;
    }

    public static int ceil(float x) {
        return (int)((double)x + 16384.999999999996) - 16384;
    }

    public static int ceilPositive(float x) {
        return (int)((double)x + 0.9999999);
    }

    public static int round(float x) {
        return (int)((double)x + 16384.5) - 16384;
    }

    public static int roundPositive(float x) {
        return (int)(x + 0.5f);
    }

    public static boolean isZero(float value) {
        return Math.abs(value) <= 1.0E-6f;
    }

    public static boolean isZero(float value, float tolerance) {
        return Math.abs(value) <= tolerance;
    }

    public static boolean isEqual(float a, float b) {
        return Math.abs(a - b) <= 1.0E-6f;
    }

    public static boolean isEqual(float a, float b, float tolerance) {
        return Math.abs(a - b) <= tolerance;
    }

    public static Vector rotateAroundAxisX(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double y = v.getY() * cos - v.getZ() * sin;
        double z = v.getY() * sin + v.getZ() * cos;
        return v.setY(y).setZ(z);
    }

    public static Vector rotateAroundAxisY(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos + v.getZ() * sin;
        double z = v.getX() * -sin + v.getZ() * cos;
        return v.setX(x).setZ(z);
    }

    public static Vector rotateAroundAxisZ(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos - v.getY() * sin;
        double y = v.getX() * sin + v.getY() * cos;
        return v.setX(x).setY(y);
    }

    public static Vector rotateVector(Vector v, double angleX, double angleY, double angleZ) {
        MathUtils.rotateAroundAxisX(v, angleX);
        MathUtils.rotateAroundAxisY(v, angleY);
        MathUtils.rotateAroundAxisZ(v, angleZ);
        return v;
    }

    public static double angleToXAxis(Vector vector) {
        return Math.atan2(vector.getX(), vector.getY());
    }

    public static Vector getRandomVector() {
        double x = random.nextDouble() * 2.0 - 1.0;
        double y = random.nextDouble() * 2.0 - 1.0;
        double z = random.nextDouble() * 2.0 - 1.0;
        return new Vector(x, y, z).normalize();
    }

    public static void applyVelocity(Entity ent, Vector v) {
        if (!ent.hasMetadata("NPC")) {
            ent.setVelocity(v);
        }
    }

    public static Vector getRandomCircleVector() {
        double rnd = random.nextDouble() * 2.0 * Math.PI;
        double x = Math.cos(rnd);
        double z = Math.sin(rnd);
        return new Vector(x, 0.0, z);
    }

    public static Material getRandomMaterial(Material[] materials) {
        return materials[random.nextInt(materials.length)];
    }

    public static double getRandomAngle() {
        return random.nextDouble() * 2.0 * Math.PI;
    }

    public static double randomDouble(double min, double max) {
        return Math.random() < 0.5 ? (1.0 - Math.random()) * (max - min) + min : Math.random() * (max - min) + min;
    }

    public static float randomRangeFloat(float min, float max) {
        return (float)(Math.random() < 0.5 ? (1.0 - Math.random()) * (double)(max - min) + (double)min : Math.random() * (double)(max - min) + (double)min);
    }

    public static byte randomByte(int max) {
        return (byte)random.nextInt(max + 1);
    }

    public static int randomRangeInt(int min, int max) {
        return (int)(Math.random() < 0.5 ? (1.0 - Math.random()) * (double)(max - min) + (double)min : Math.random() * (double)(max - min) + (double)min);
    }

    public static double offset(Entity a, Entity b) {
        return MathUtils.offset(a.getLocation().toVector(), b.getLocation().toVector());
    }

    public static double offset(Location a, Location b) {
        return MathUtils.offset(a.toVector(), b.toVector());
    }

    public static double offset(Vector a, Vector b) {
        return a.subtract(b).length();
    }

    static {
        random = new Random();
        INV_ATAN2_DIM_MINUS_1 = 1.0f / (float)(ATAN2_DIM - 1);
        random = new Random();
    }

    private static class Sin {
        static final float[] table;

        private Sin() {
        }

        static {
            int i;
            table = new float[16384];
            for (i = 0; i < 16384; ++i) {
                Sin.table[i] = (float)Math.sin(((float)i + 0.5f) / 16384.0f * ((float)Math.PI * 2));
            }
            for (i = 0; i < 360; i += 90) {
                Sin.table[(int)((float)i * 45.511112f) & 0x3FFF] = (float)Math.sin((float)i * ((float)Math.PI / 180));
            }
        }
    }

    private static class Atan2 {
        static final float[] table = new float[16384];

        private Atan2() {
        }

        static {
            for (int i = 0; i < ATAN2_DIM; ++i) {
                for (int j = 0; j < ATAN2_DIM; ++j) {
                    float x0 = (float)i / (float)ATAN2_DIM;
                    float y0 = (float)j / (float)ATAN2_DIM;
                    Atan2.table[j * MathUtils.ATAN2_DIM + i] = (float)Math.atan2(y0, x0);
                }
            }
        }
    }
}

