/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.item.meta;

import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import simplepets.brainsynder.libs.bslib.item.MetaHandler;
import simplepets.brainsynder.libs.bslib.json.Json;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.utils.Base64Wrapper;

public class SkullMetaHandler
extends MetaHandler<SkullMeta> {
    public SkullMetaHandler(SkullMeta meta) {
        super(meta);
    }

    @Override
    public void fromItemMeta(ItemMeta meta) {
        String texture;
        if (!(meta instanceof SkullMeta)) {
            return;
        }
        SkullMeta skullMeta = (SkullMeta)meta;
        StorageTagCompound compound = new StorageTagCompound();
        if (skullMeta.hasOwner() && !skullMeta.getOwner().equals("Steve")) {
            compound.setString("owner", skullMeta.getOwner());
        }
        if (skullMeta.getOwnerProfile() != null && (texture = SkullMetaHandler.getTexture(skullMeta.getOwnerProfile())) != null && !texture.isEmpty()) {
            compound.setString("texture", texture);
        }
        this.updateCompound(compound);
    }

    @Override
    public void fromCompound(StorageTagCompound compound) {
        super.fromCompound(compound);
        this.modifyMeta(value -> {
            if (compound.hasKey("owner")) {
                value.setOwner(compound.getString("owner"));
            }
            if (compound.hasKey("texture")) {
                String texture = compound.getString("texture");
                if (texture == null) {
                    return value;
                }
                if (texture.isEmpty()) {
                    return value;
                }
                if (!texture.startsWith("http") && Base64Wrapper.isEncoded(texture)) {
                    texture = Base64Wrapper.decodeString(texture);
                    texture = Json.parse(texture).asObject().get("textures").asObject().get("SKIN").asObject().get("url").asString();
                }
                String finalTexture = texture;
                value.setOwnerProfile(SkullMetaHandler.createProfile(finalTexture));
            }
            return value;
        });
    }
}

