/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.item.meta;

import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import simplepets.brainsynder.libs.bslib.item.MetaHandler;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagList;

public class PotionMetaHandler
extends MetaHandler<PotionMeta> {
    public PotionMetaHandler(PotionMeta meta) {
        super(meta);
    }

    @Override
    public void fromItemMeta(ItemMeta meta) {
        if (!(meta instanceof PotionMeta)) {
            return;
        }
        PotionMeta potionMeta = (PotionMeta)meta;
        StorageTagCompound compound = new StorageTagCompound();
        if (potionMeta.hasColor()) {
            compound.setColor("color", potionMeta.getColor());
        }
        if (!potionMeta.getCustomEffects().isEmpty()) {
            StorageTagList list = new StorageTagList();
            potionMeta.getCustomEffects().forEach(potionEffect -> {
                StorageTagCompound effect = new StorageTagCompound();
                effect.setString("type", potionEffect.getType().getName());
                effect.setBoolean("ambient", potionEffect.isAmbient());
                effect.setBoolean("particles", potionEffect.hasParticles());
                effect.setInteger("amplifier", potionEffect.getAmplifier());
                effect.setInteger("duration", potionEffect.getDuration());
                effect.setBoolean("icon", potionEffect.hasIcon());
                list.appendTag(effect);
            });
            compound.setTag("effects", list);
        }
        this.updateCompound(compound);
    }

    @Override
    public void fromCompound(StorageTagCompound compound) {
        super.fromCompound(compound);
        this.modifyMeta(value -> {
            if (compound.hasKey("color")) {
                value.setColor(compound.getColor("color"));
            }
            if (compound.hasKey("effects")) {
                StorageTagList list = (StorageTagList)compound.getTag("effects");
                list.getTagList().forEach(base -> {
                    StorageTagCompound effect = (StorageTagCompound)base;
                    PotionEffect potionEffect = new PotionEffect(PotionEffectType.getByName((String)effect.getString("type", "SPEED")), effect.getInteger("duration", 60), effect.getInteger("amplifier", 1), effect.getBoolean("ambient", true), effect.getBoolean("particles", true), effect.getBoolean("icon", true));
                    value.addCustomEffect(potionEffect, false);
                });
            }
            return value;
        });
    }
}

