/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.item.meta;

import java.util.ArrayList;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.KnowledgeBookMeta;
import simplepets.brainsynder.libs.bslib.item.MetaHandler;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagList;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagString;

public class KnowledgeBookMetaHandler
extends MetaHandler<KnowledgeBookMeta> {
    public KnowledgeBookMetaHandler(KnowledgeBookMeta meta) {
        super(meta);
    }

    @Override
    public void fromItemMeta(ItemMeta meta) {
        if (!(meta instanceof KnowledgeBookMeta)) {
            return;
        }
        KnowledgeBookMeta book = (KnowledgeBookMeta)meta;
        if (!book.getRecipes().isEmpty()) {
            StorageTagList list = new StorageTagList();
            book.getRecipes().forEach(key -> list.appendTag(new StorageTagString(key.toString())));
            this.updateCompound(new StorageTagCompound().setTag("recipes", list));
        }
    }

    @Override
    public void fromCompound(StorageTagCompound compound) {
        super.fromCompound(compound);
        if (compound.hasKey("recipes")) {
            ArrayList recipes = new ArrayList();
            StorageTagList list = (StorageTagList)compound.getTag("recipes");
            list.getTagList().forEach(storageBase -> {
                String[] args = ((StorageTagString)storageBase).getString().split(":");
                recipes.add(new NamespacedKey(args[0], args[1]));
            });
            this.modifyMeta(value -> {
                value.setRecipes(recipes);
                return value;
            });
        }
    }
}

