/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.item.meta;

import java.util.ArrayList;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import simplepets.brainsynder.libs.bslib.item.MetaHandler;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagList;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagString;

public class FireworkMetaHandler
extends MetaHandler<FireworkMeta> {
    public FireworkMetaHandler(FireworkMeta meta) {
        super(meta);
    }

    @Override
    public void fromItemMeta(ItemMeta meta) {
        if (!(meta instanceof FireworkMeta)) {
            return;
        }
        FireworkMeta firework = (FireworkMeta)meta;
        StorageTagCompound compound = new StorageTagCompound();
        if (firework.getPower() != 0) {
            compound.setInteger("power", firework.getPower());
        }
        if (!firework.getEffects().isEmpty()) {
            StorageTagList list = new StorageTagList();
            firework.getEffects().forEach(effect -> list.appendTag(this.toCompound((FireworkEffect)effect)));
            compound.setTag("effects", list);
        }
        this.updateCompound(compound);
    }

    @Override
    public void fromCompound(StorageTagCompound compound) {
        super.fromCompound(compound);
        if (compound.hasKey("power")) {
            this.modifyMeta(value -> {
                value.setPower(compound.getInteger("power"));
                return value;
            });
        }
        if (compound.hasKey("effects")) {
            ArrayList effects = new ArrayList();
            StorageTagList list = (StorageTagList)compound.getTag("effects");
            list.getTagList().forEach(storageBase -> effects.add(this.fromCompoundEffect((StorageTagCompound)storageBase)));
            this.modifyMeta(value -> {
                value.addEffects((Iterable)effects);
                return value;
            });
        }
    }

    private FireworkEffect fromCompoundEffect(StorageTagCompound compound) {
        StorageTagList list;
        ArrayList colors;
        FireworkEffect.Builder builder = FireworkEffect.builder();
        builder.with(FireworkEffect.Type.valueOf((String)compound.getString("type", "BALL")));
        if (compound.hasKey("trail")) {
            builder.trail(compound.getBoolean("trail"));
        }
        if (compound.hasKey("flicker")) {
            builder.flicker(compound.getBoolean("flicker"));
        }
        if (compound.hasKey("colors")) {
            colors = new ArrayList();
            list = (StorageTagList)compound.getTag("colors");
            list.getTagList().forEach(storageBase -> colors.add(((StorageTagString)storageBase).getAsColor()));
            builder.withColor(colors);
        }
        if (compound.hasKey("fade-colors")) {
            colors = new ArrayList();
            list = (StorageTagList)compound.getTag("fade-colors");
            list.getTagList().forEach(storageBase -> colors.add(((StorageTagString)storageBase).getAsColor()));
            builder.withFade(colors);
        }
        return builder.build();
    }

    private StorageTagCompound toCompound(FireworkEffect effect) {
        StorageTagCompound compound = new StorageTagCompound();
        compound.setString("type", effect.getType().name());
        if (effect.hasTrail()) {
            compound.setBoolean("trail", true);
        }
        if (effect.hasFlicker()) {
            compound.setBoolean("flicker", true);
        }
        if (!effect.getColors().isEmpty()) {
            StorageTagList colors = new StorageTagList();
            effect.getColors().forEach(color -> colors.appendTag(new StorageTagString((Color)color)));
            compound.setTag("colors", colors);
        }
        if (!effect.getFadeColors().isEmpty()) {
            StorageTagList fade = new StorageTagList();
            effect.getFadeColors().forEach(color -> fade.appendTag(new StorageTagString((Color)color)));
            compound.setTag("fade-colors", fade);
        }
        return compound;
    }
}

