/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.item.meta;

import java.util.ArrayList;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import simplepets.brainsynder.libs.bslib.item.MetaHandler;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagList;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagString;

public class BookMetaHandler
extends MetaHandler<BookMeta> {
    public BookMetaHandler(BookMeta meta) {
        super(meta);
    }

    @Override
    public void fromItemMeta(ItemMeta meta) {
        if (!(meta instanceof BookMeta)) {
            return;
        }
        BookMeta book = (BookMeta)meta;
        StorageTagCompound compound = new StorageTagCompound();
        if (book.getTitle() != null && !book.getTitle().isEmpty()) {
            compound.setString("title", book.getTitle());
        }
        if (!book.getAuthor().isEmpty()) {
            compound.setString("author", book.getAuthor());
        }
        if (book.getGeneration() != null) {
            compound.setString("generation", book.getGeneration().name());
        }
        if (!book.getPages().isEmpty()) {
            StorageTagList list = new StorageTagList();
            this.translate(book.getPages(), true).forEach(page -> list.appendTag(new StorageTagString(this.translate((String)page, true))));
            compound.setTag("pages", list);
        }
        this.updateCompound(compound);
    }

    @Override
    public void fromCompound(StorageTagCompound compound) {
        this.modifyMeta(value -> {
            if (compound.hasKey("title")) {
                value.setTitle(this.translate(compound.getString("title")));
            }
            if (compound.hasKey("author")) {
                value.setAuthor(compound.getString("author"));
            }
            if (compound.hasKey("generation")) {
                value.setGeneration(BookMeta.Generation.valueOf((String)compound.getString("generation")));
            }
            if (compound.hasKey("pages")) {
                ArrayList<String> pages = new ArrayList<String>();
                StorageTagList list = (StorageTagList)compound.getTag("patterns");
                list.getTagList().forEach(storageBase -> pages.add(((StorageTagString)storageBase).getString()));
                value.setPages(this.translate(pages));
            }
            return value;
        });
    }
}

