/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.item.meta;

import java.util.ArrayList;
import org.bukkit.DyeColor;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import simplepets.brainsynder.libs.bslib.item.MetaHandler;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagList;

public class BannerMetaHandler
extends MetaHandler<BannerMeta> {
    public BannerMetaHandler(BannerMeta meta) {
        super(meta);
    }

    @Override
    public void fromItemMeta(ItemMeta meta) {
        if (!(meta instanceof BannerMeta)) {
            return;
        }
        BannerMeta bannerMeta = (BannerMeta)meta;
        if (!bannerMeta.getPatterns().isEmpty()) {
            StorageTagList list = new StorageTagList();
            bannerMeta.getPatterns().forEach(pattern -> {
                StorageTagCompound tagCompound = new StorageTagCompound();
                tagCompound.setString("type", pattern.getPattern().name());
                tagCompound.setString("color", pattern.getColor().name());
                list.appendTag(tagCompound);
            });
            this.updateCompound(new StorageTagCompound().setTag("patterns", list));
        }
    }

    @Override
    public void fromCompound(StorageTagCompound compound) {
        super.fromCompound(compound);
        if (compound.hasKey("patterns")) {
            ArrayList patterns = new ArrayList();
            StorageTagList list = (StorageTagList)compound.getTag("patterns");
            list.getTagList().forEach(storageBase -> {
                StorageTagCompound tagCompound = (StorageTagCompound)storageBase;
                PatternType type = PatternType.valueOf((String)tagCompound.getString("type", "BASE"));
                DyeColor color = DyeColor.valueOf((String)tagCompound.getString("color", "WHITE"));
                patterns.add(new Pattern(color, type));
            });
            this.modifyMeta(value -> {
                value.setPatterns(patterns);
                return value;
            });
        }
    }
}

