/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import simplepets.brainsynder.libs.bslib.apache.WordUtils;
import simplepets.brainsynder.libs.bslib.item.ItemTools;
import simplepets.brainsynder.libs.bslib.json.Json;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagList;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagString;
import simplepets.brainsynder.libs.bslib.utils.Base64Wrapper;
import simplepets.brainsynder.libs.bslib.utils.Colorize;

public class ItemBuilder {
    private Map<String, String> masterReplace = new HashMap<String, String>();
    private Map<String, String> replaceLore = new HashMap<String, String>();
    private Map<String, String> replaceName = new HashMap<String, String>();
    private final ItemStack item;
    private ItemMeta meta;

    public ItemBuilder(Material material) {
        this(material, 1);
    }

    public ItemBuilder(Material material, int amount) {
        this.item = new ItemStack(material, amount);
        this.meta = this.item.getItemMeta();
    }

    public static ItemBuilder fromCompound(StorageTagCompound compound) {
        StorageTagList list;
        Material material = Material.getMaterial((String)compound.getString("material"));
        ItemBuilder builder = new ItemBuilder(material, compound.getInteger("amount", 1));
        if (compound.hasKey("enchants")) {
            StorageTagList enchants = (StorageTagList)compound.getTag("enchants");
            enchants.getTagList().forEach(base -> {
                StorageTagCompound enchant = (StorageTagCompound)base;
                Enchantment enchantment = Enchantment.getByName((String)enchant.getString("name"));
                int level = enchant.getInteger("level", 1);
                builder.withEnchant(enchantment, level);
            });
        }
        if (compound.hasKey("durability")) {
            builder.withDurability(compound.getInteger("durability"));
        }
        if (compound.hasKey("name")) {
            builder.withName(compound.getString("name"));
        }
        if (compound.hasKey("custom-model-data")) {
            builder.withCustomModel(compound.getInteger("custom-model-data"));
        } else if (compound.hasKey("CustomModelData")) {
            builder.withCustomModel(compound.getInteger("CustomModelData"));
        }
        if (compound.hasKey("unbreakable")) {
            builder.setUnbreakable(compound.getBoolean("unbreakable"));
        }
        if (compound.hasKey("lore")) {
            list = (StorageTagList)compound.getTag("lore");
            ArrayList<String> lore = new ArrayList<String>();
            list.getTagList().forEach(storageBase -> lore.add(((StorageTagString)storageBase).getString()));
            builder.withLore(lore);
        }
        if (compound.hasKey("flags")) {
            list = (StorageTagList)compound.getTag("flags");
            list.getTagList().forEach(storageBase -> {
                ItemFlag flag = ItemFlag.valueOf((String)((StorageTagString)storageBase).getString());
                builder.withFlag(flag);
            });
        }
        if (compound.hasKey("meta")) {
            ItemTools.fromCompound(builder.meta, compound.getCompoundTag("meta"));
        }
        return builder;
    }

    public static ItemBuilder fromItem(ItemStack item) {
        ItemBuilder builder = new ItemBuilder(item.getType(), item.getAmount());
        if (!item.getEnchantments().isEmpty()) {
            item.getEnchantments().forEach(builder::withEnchant);
        }
        if (item.getDurability() >= 0) {
            builder.withDurability(item.getDurability());
        }
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            if (meta.hasDisplayName()) {
                builder.withName(meta.getDisplayName());
            }
            if (meta.hasLore()) {
                builder.withLore(meta.getLore());
            }
            if (!meta.getItemFlags().isEmpty()) {
                meta.getItemFlags().forEach(builder::withFlag);
            }
            builder.meta = meta;
        }
        return builder;
    }

    public ItemBuilder replaceInName(String key, Object replacement) {
        this.replaceName.put(key, String.valueOf(replacement));
        return this;
    }

    public ItemBuilder replaceString(String key, Object replacement) {
        this.masterReplace.put(key, String.valueOf(replacement));
        return this;
    }

    public ItemBuilder replaceInLore(String key, Object replacement) {
        this.replaceLore.put(key, String.valueOf(replacement));
        return this;
    }

    public ItemBuilder withLore(List<String> lore) {
        this.meta.setLore(this.translate(lore, false));
        return this;
    }

    public ItemBuilder addLore(String ... lore) {
        List itemLore = new ArrayList();
        if (this.meta.hasLore()) {
            itemLore = this.meta.getLore();
        }
        ArrayList finalItemLore = itemLore;
        Arrays.asList(lore).forEach(s -> finalItemLore.add(this.translate((String)s, false)));
        this.meta.setLore(finalItemLore);
        return this;
    }

    public ItemBuilder clearLore() {
        if (this.meta.hasLore()) {
            this.meta.getLore().clear();
        }
        return this;
    }

    public ItemBuilder removeLore(String lore) {
        List itemLore = new ArrayList();
        if (this.meta.hasLore()) {
            itemLore = this.meta.getLore();
        }
        itemLore.remove(this.translate(lore, false));
        this.meta.setLore(itemLore);
        return this;
    }

    public ItemBuilder withEnchant(Enchantment enchant, int level) {
        this.item.addUnsafeEnchantment(enchant, level);
        return this;
    }

    public ItemBuilder removeEnchant(Enchantment enchant) {
        this.item.removeEnchantment(enchant);
        return this;
    }

    public ItemBuilder withCustomModel(int customModelData) {
        this.meta.setCustomModelData(Integer.valueOf(customModelData));
        return this;
    }

    public ItemBuilder withFlag(ItemFlag flag) {
        this.meta.addItemFlags(new ItemFlag[]{flag});
        return this;
    }

    public ItemBuilder removeFlag(ItemFlag flag) {
        this.meta.removeItemFlags(new ItemFlag[]{flag});
        return this;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        this.meta.setUnbreakable(unbreakable);
        return this;
    }

    public boolean isUnbreakable() {
        return this.meta.isUnbreakable();
    }

    public ItemBuilder withName(String name) {
        this.meta.setDisplayName(this.translate(name, false));
        return this;
    }

    public ItemBuilder withDurability(int durability) {
        this.item.setDurability((short)durability);
        return this;
    }

    public String getName() {
        if (this.meta.hasDisplayName()) {
            return this.meta.getDisplayName();
        }
        return WordUtils.capitalizeFully(this.item.getType().name().toLowerCase().replace("_", " "));
    }

    public ItemStack build() {
        if (this.item == null) {
            return new ItemStack(Material.STONE);
        }
        if (this.item.getType() == Material.AIR) {
            return this.item;
        }
        ArrayList<String> newLore = new ArrayList<String>();
        if (this.meta.hasLore()) {
            for (String line : this.meta.getLore()) {
                String replacement;
                String key;
                for (Map.Entry<String, String> entry : this.replaceLore.entrySet()) {
                    key = entry.getKey();
                    replacement = entry.getValue();
                    line = line.replace(key, replacement);
                }
                for (Map.Entry<String, String> entry : this.masterReplace.entrySet()) {
                    key = entry.getKey();
                    replacement = entry.getValue();
                    line = line.replace(key, replacement);
                }
                newLore.add(Colorize.translateBungeeHex(line));
            }
            this.meta.setLore(newLore);
        }
        if (this.meta.hasDisplayName()) {
            String replacement;
            String key;
            String name = this.meta.getDisplayName();
            for (Map.Entry<String, String> entry : this.replaceName.entrySet()) {
                key = entry.getKey();
                replacement = entry.getValue();
                name = name.replace(key, replacement);
            }
            for (Map.Entry<String, String> entry : this.masterReplace.entrySet()) {
                key = entry.getKey();
                replacement = entry.getValue();
                name = name.replace(key, replacement);
            }
            this.meta.setDisplayName(Colorize.translateBungeeHex(name));
        }
        this.item.setItemMeta(this.meta);
        return this.item;
    }

    public boolean isSimilar(ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemStack main = this.build();
        if (main.getType() == item.getType() && item.hasItemMeta() && main.hasItemMeta()) {
            ItemMeta mainMeta = main.getItemMeta();
            ItemMeta checkMeta = item.getItemMeta();
            if (mainMeta.hasDisplayName() && checkMeta.hasDisplayName() && !mainMeta.getDisplayName().equals(checkMeta.getDisplayName())) {
                return false;
            }
            if (mainMeta.hasLore() && checkMeta.hasLore() && !mainMeta.getLore().equals(checkMeta.getLore())) {
                return false;
            }
            if (!mainMeta.getItemFlags().equals(checkMeta.getItemFlags())) {
                return false;
            }
            if (mainMeta.hasEnchants() && checkMeta.hasEnchants() && !mainMeta.getEnchants().equals(checkMeta.getEnchants())) {
                return false;
            }
            if (mainMeta.hasCustomModelData() && checkMeta.hasCustomModelData() && mainMeta.getCustomModelData() != checkMeta.getCustomModelData()) {
                return false;
            }
            return ItemTools.toCompound(mainMeta).equals(ItemTools.toCompound(checkMeta));
        }
        return main.isSimilar(item);
    }

    public boolean isSimilar(ItemBuilder builder) {
        if (builder == null) {
            return false;
        }
        return this.isSimilar(builder.build());
    }

    public ItemBuilder clone() {
        ItemBuilder builder = ItemBuilder.fromCompound(this.toCompound());
        builder.replaceName = this.replaceName;
        builder.replaceLore = this.replaceLore;
        builder.masterReplace = this.masterReplace;
        return builder;
    }

    public ItemBuilder setTexture(String texture) {
        if (texture == null) {
            return this;
        }
        if (texture.isEmpty()) {
            return this;
        }
        if (!texture.startsWith("http") && Base64Wrapper.isEncoded(texture)) {
            texture = Base64Wrapper.decodeString(texture);
            texture = Json.parse(texture).asObject().get("textures").asObject().get("SKIN").asObject().get("url").asString();
        }
        String finalTexture = texture;
        this.handleMeta(SkullMeta.class, value -> {
            value.setOwnerProfile(ItemTools.createProfile(finalTexture));
            return value;
        });
        return this;
    }

    public String getTexture() {
        return this.getMetaValue(SkullMeta.class, value -> ItemTools.getTexture(ItemTools.getGameProfile(value)));
    }

    public StorageTagCompound toCompound() {
        StorageTagCompound meta;
        StorageTagCompound compound = new StorageTagCompound();
        compound.setEnum("material", (Enum)this.item.getType());
        if (this.item.getAmount() > 1) {
            compound.setInteger("amount", this.item.getAmount());
        }
        if (this.meta.hasDisplayName()) {
            compound.setString("name", Colorize.removeHexColor(this.meta.getDisplayName().replace('\u00a7', '&')));
        }
        if (this.meta.isUnbreakable()) {
            compound.setBoolean("unbreakable", this.meta.isUnbreakable());
        }
        if (this.item.getDurability() > 0) {
            compound.setInteger("durability", this.item.getDurability());
        }
        if (this.meta.hasCustomModelData()) {
            compound.setInteger("CustomModelData", this.meta.getCustomModelData());
        }
        if (this.meta.hasLore()) {
            StorageTagList lore = new StorageTagList();
            this.meta.getLore().forEach(line -> lore.appendTag(new StorageTagString(Colorize.removeHexColor(line.replace('\u00a7', '&')).replace("\"", ""))));
            compound.setTag("lore", lore);
        }
        if (!this.item.getEnchantments().isEmpty()) {
            StorageTagList enchants = new StorageTagList();
            this.item.getEnchantments().forEach((enchantment, level) -> {
                StorageTagCompound enchant = new StorageTagCompound();
                enchant.setString("name", enchantment.getName());
                enchant.setInteger("level", (int)level);
                enchants.appendTag(enchant);
            });
            compound.setTag("enchants", enchants);
        }
        if (!this.meta.getItemFlags().isEmpty()) {
            StorageTagList flags = new StorageTagList();
            this.meta.getItemFlags().forEach(itemFlag -> flags.appendTag(new StorageTagString(itemFlag.name())));
            compound.setTag("flags", flags);
        }
        if (!(meta = ItemTools.toCompound(this.meta)).hasNoTags()) {
            compound.setTag("meta", meta);
        }
        return compound;
    }

    private List<String> translate(List<String> message, boolean strip) {
        ArrayList<String> newLore = new ArrayList<String>();
        message.forEach(msg -> {
            if (strip) {
                msg = msg.replace('\u00a7', '&');
                msg = Colorize.removeHexColor(msg);
            } else {
                msg = Colorize.translateBungeeHex(msg);
            }
            newLore.add((String)msg);
        });
        return newLore;
    }

    private String translate(String message, boolean strip) {
        if (strip) {
            message = message.replace('\u00a7', '&');
            message = Colorize.removeHexColor(message);
        } else {
            message = Colorize.translateBungeeHex(message);
        }
        return message;
    }

    public static boolean isAir(Material mat) {
        return mat.name().endsWith("AIR") && !mat.name().endsWith("AIRS");
    }

    public static boolean isAir(ItemStack item) {
        return item == null || ItemBuilder.isAir(item.getType());
    }

    public <T extends ItemMeta> ItemBuilder handleMeta(Class<T> clazz, InnerReturn<T> meta) {
        if (!clazz.isAssignableFrom(this.meta.getClass())) {
            return this;
        }
        this.meta = meta.run(this.meta);
        this.item.setItemMeta(this.meta);
        return this;
    }

    public <R, T> R getMetaValue(Class<T> clazz, InnerReturnValue<T, R> meta) {
        if (!clazz.isAssignableFrom(this.meta.getClass())) {
            return null;
        }
        return meta.run(this.meta);
    }

    public static interface InnerReturn<T> {
        public T run(T var1);
    }

    public static interface InnerReturnValue<T, R> {
        public R run(T var1);
    }
}

