/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.plugin.tests.proxy;

import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.NBT;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.NBTItem;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.NbtApiException;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.data.proxy.NBTItemMeta;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.iface.ReadWriteNBT;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.plugin.tests.Test;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.utils.MinecraftVersion;

public class DataItemProxyTest
implements Test {
    @Override
    public void test() throws Exception {
        ItemStack item = new ItemStack(Material.STONE);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName("Test");
        item.setItemMeta(meta);
        NBT.modify(item, NBTItemMeta.class, nmeta -> {
            nmeta.setCustomModelData(123);
            nmeta.setUnbreakable(true);
            if (!nmeta.getDisplayData().getRawName().contains("Test")) {
                throw new NbtApiException("Raw name didn't containg the expected String: " + nmeta);
            }
            ReadWriteNBT container = NBT.createNBTObject();
            container.setString("foo", "bar");
            nmeta.setBlockStateTag(container);
            if (!container.equals(nmeta.getBlockStateTag())) {
                throw new NbtApiException("BlockStateTag did not match! " + nmeta);
            }
        });
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_16_R1)) {
            meta = item.getItemMeta();
            if (!meta.hasCustomModelData() || meta.getCustomModelData() != 123) {
                throw new NbtApiException("Custom Model Data did not match! " + new NBTItem(item));
            }
            if (!meta.isUnbreakable()) {
                throw new NbtApiException("Unbreakable did not set!");
            }
        }
    }
}

