/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.bukkit.util.Vector;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.NBTCompound;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.NBTFile;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.NbtApiException;

public class WorldData {
    private final NBTFile file;

    protected WorldData(File worldFolder) throws IOException {
        if (!new File(worldFolder, "level.dat").exists()) {
            throw new FileNotFoundException("Level.dat at: " + new File(worldFolder, "level.dat").getAbsolutePath());
        }
        this.file = new NBTFile(new File(worldFolder, "level.dat"));
    }

    public NBTFile getFile() {
        return this.file;
    }

    public NBTCompound getCompound() {
        return this.file;
    }

    public void saveChanges() {
        try {
            this.file.save();
        }
        catch (IOException e) {
            throw new NbtApiException("Error when saving level data!", e);
        }
    }

    public String getWorldName() {
        return (String)this.file.resolveOrNull("Data.LevelName", String.class);
    }

    public void setWorldName(String name) {
        this.file.getOrCreateCompound("Data").setString("LevelName", name);
    }

    public Vector getSpawnPosition() {
        NBTCompound data = this.file.getCompound("Data");
        if (data == null) {
            return null;
        }
        return new Vector(data.getInteger("SpawnX").intValue(), data.getInteger("SpawnY").intValue(), data.getInteger("SpawnZ").intValue());
    }

    public void setSpawnPosition(Vector vec) {
        NBTCompound data = this.file.getOrCreateCompound("Data");
        data.setInteger("SpawnX", vec.getBlockX());
        data.setInteger("SpawnY", vec.getBlockY());
        data.setInteger("SpawnZ", vec.getBlockZ());
    }
}

