/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.data;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.NBTFile;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.NbtApiException;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.data.PlayerData;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.data.WorldData;

public class NBTData {
    public static WorldData getWorldData(World world) {
        try {
            return new WorldData(world.getWorldFolder());
        }
        catch (IOException e) {
            throw new NbtApiException("Error loading World Data!", e);
        }
    }

    public static WorldData getWorldData(File worldFolder) {
        try {
            return new WorldData(worldFolder);
        }
        catch (IOException e) {
            throw new NbtApiException("Error loading World Data!", e);
        }
    }

    public static PlayerData getOfflinePlayerData(UUID uuid) {
        for (World world : Bukkit.getWorlds()) {
            File dataFolder = new File(world.getWorldFolder(), "playerdata");
            File playerFile = new File(dataFolder, uuid.toString() + ".dat");
            if (!playerFile.exists()) continue;
            try {
                return new PlayerData(playerFile);
            }
            catch (IOException e) {
                throw new NbtApiException("Error loading player data!", e);
            }
        }
        return null;
    }

    public static NBTFile getPluginPlayerData(Plugin plugin, UUID uuid) {
        try {
            File dataFolder = new File(plugin.getDataFolder(), "nbt-playerdata");
            dataFolder.mkdirs();
            return new NBTFile(new File(dataFolder, uuid.toString() + ".dat"));
        }
        catch (IOException e) {
            throw new NbtApiException("Error getting Player Plugin data!", e);
        }
    }

    public static NBTFile getPluginData(Plugin plugin) {
        try {
            plugin.getDataFolder().mkdirs();
            return new NBTFile(new File(plugin.getDataFolder(), "settings.dat"));
        }
        catch (IOException e) {
            throw new NbtApiException("Error getting Plugin data!", e);
        }
    }
}

