/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import simplepets.brainsynder.libs.bslib.files.Movable;
import simplepets.brainsynder.libs.bslib.nbt.CompressedStreamTools;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;

public class StorageFile
extends StorageTagCompound
implements Movable {
    private final File file;

    public StorageFile(File file) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            FileInputStream stream = new FileInputStream(file);
            StorageTagCompound compound = CompressedStreamTools.readCompressed(stream);
            compound.getKeySet().forEach(key -> this.setTag((String)key, compound.getTag((String)key)));
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.file = file;
    }

    public StorageFile setDefault(StorageTagCompound compound) {
        compound.getKeySet().forEach(key -> this.setTag((String)key, compound.getTag((String)key)));
        return this;
    }

    public void save() {
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            FileOutputStream stream = new FileOutputStream(this.file);
            CompressedStreamTools.writeCompressed(this, stream);
            stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean move(String oldKey, String newKey) {
        if (this.hasKey(oldKey)) {
            this.setTag(newKey, this.getTag(oldKey));
            this.remove(oldKey);
            this.save();
            return true;
        }
        return false;
    }

    public File getFile() {
        return this.file;
    }
}

