/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import simplepets.brainsynder.libs.bslib.commands.SubCommand;
import simplepets.brainsynder.libs.bslib.commands.annotations.ICommand;
import simplepets.brainsynder.libs.bslib.nms.Tellraw;
import simplepets.brainsynder.libs.bslib.utils.Colorize;

public class ParentCommand<T extends SubCommand>
extends SubCommand {
    protected boolean overrideTab = false;
    private final List<T> subCommands = new ArrayList<T>();

    public void sendHelp(CommandSender sender, boolean parent) {
        if (parent) {
            this.sendUsage(sender);
        }
        if (!this.subCommands.isEmpty()) {
            this.subCommands.forEach(subCommand -> {
                if (!subCommand.getMasterFormat().equals(this.getMasterFormat())) {
                    subCommand.setMasterFormat(this.getMasterFormat());
                }
                subCommand.sendUsage(sender);
            });
        }
    }

    @Override
    public void sendUsage(CommandSender sender) {
        ICommand command = this.getCommand(this.getClass());
        if (command == null) {
            return;
        }
        String usage = Colorize.translateBungeeHex(command.usage());
        String description = "";
        Tellraw raw = Tellraw.getInstance("/" + command.name() + " " + usage);
        if (!command.description().isEmpty()) {
            description = Colorize.translateBungeeHex(command.description());
            raw.tooltip(String.valueOf(ChatColor.GRAY) + description);
        }
        if (!(sender instanceof Player) && !description.isEmpty()) {
            raw.then(" " + description);
        }
        raw.send(sender);
    }

    @Override
    public void tabComplete(List<String> completions, CommandSender sender, String[] args) {
        Objects.requireNonNull(sender, "Sender cannot be null");
        Objects.requireNonNull(args, "Arguments cannot be null");
        if (!this.subCommands.isEmpty() && !this.overrideTab && args.length == 1) {
            String toComplete = args[0].toLowerCase(Locale.ENGLISH);
            for (SubCommand command : this.subCommands) {
                ICommand annotation;
                if (!command.getClass().isAnnotationPresent(ICommand.class) || !command.canExecute(sender) || (annotation = command.getClass().getAnnotation(ICommand.class)).name().isEmpty()) continue;
                if (StringUtil.startsWithIgnoreCase((String)annotation.name(), (String)toComplete)) {
                    completions.add(annotation.name());
                }
                Arrays.asList(annotation.alias()).forEach(name -> {
                    if (StringUtil.startsWithIgnoreCase((String)name, (String)toComplete)) {
                        completions.add((String)name);
                    }
                });
            }
        }
        super.tabComplete(completions, sender, args);
    }

    public PluginCommand getBukkitCommand() {
        ICommand command = this.getCommand(this.getClass());
        return Bukkit.getPluginCommand((String)command.name());
    }

    protected void registerSub(T subCommand) {
        this.subCommands.add(subCommand);
    }

    public List<T> getSubCommands() {
        return this.subCommands;
    }

    private T parse(String name) {
        SubCommand sub = null;
        for (SubCommand command : this.subCommands) {
            ICommand annotation;
            if (!command.getClass().isAnnotationPresent(ICommand.class) || (annotation = command.getClass().getAnnotation(ICommand.class)).name().isEmpty() || !annotation.name().equalsIgnoreCase(name) && !Arrays.asList(annotation.alias()).contains(name)) continue;
            sub = command;
            break;
        }
        return (T)sub;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        try {
            if (args.length == 0) {
                if (this.canExecute(sender)) {
                    this.run(sender);
                }
            } else {
                String args0 = args[0];
                T sub = this.parse(args0);
                if (sub == null) {
                    if (this.canExecute(sender)) {
                        this.run(sender, args);
                    }
                    return false;
                }
                if (((SubCommand)sub).canExecute(sender)) {
                    ((SubCommand)sub).run(sender, this.newArgs(args));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command cmd, String s, String[] args) {
        Objects.requireNonNull(sender, "Sender cannot be null");
        Objects.requireNonNull(args, "Arguments cannot be null");
        ArrayList<String> completions = new ArrayList<String>();
        this.tabComplete(completions, sender, args);
        if (!completions.isEmpty()) {
            return completions;
        }
        if (args.length >= 1) {
            String args0 = args[0];
            SubCommand sub = null;
            for (SubCommand command : this.subCommands) {
                ICommand annotation;
                if (!command.getClass().isAnnotationPresent(ICommand.class) || (annotation = command.getClass().getAnnotation(ICommand.class)).name().isEmpty() || !annotation.name().equalsIgnoreCase(args0) && !Arrays.asList(annotation.alias()).contains(args0)) continue;
                sub = command;
                break;
            }
            if (sub != null) {
                ArrayList newArgs = new ArrayList();
                Collections.addAll(newArgs, args);
                newArgs.remove(0);
                String[] arguments = newArgs.toArray(new String[newArgs.size()]);
                sub.tabComplete(completions, sender, arguments);
                if (!completions.isEmpty()) {
                    return completions;
                }
            }
        }
        return new ArrayList<String>();
    }
}

