/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.commands;

import java.util.Arrays;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;
import simplepets.brainsynder.libs.bslib.commands.ParentCommand;
import simplepets.brainsynder.libs.bslib.commands.annotations.ICommand;

public class CommandRegistry<P extends JavaPlugin> {
    private P plugin;

    public CommandRegistry(P plugin) {
        this.plugin = plugin;
    }

    public void register(ParentCommand commandCore) throws Exception {
        Class<?> clazz = commandCore.getClass();
        if (!clazz.isAnnotationPresent(ICommand.class)) {
            throw new Exception(clazz.getSimpleName() + " Missing ICommand.class");
        }
        ICommand annotation = clazz.getAnnotation(ICommand.class);
        if (annotation.name().isEmpty()) {
            throw new Exception(clazz.getSimpleName() + " missing name");
        }
        PluginCommand command = this.plugin.getCommand(annotation.name());
        command.setExecutor((CommandExecutor)commandCore);
        command.setTabCompleter((TabCompleter)commandCore);
        if (!annotation.description().isEmpty()) {
            command.setDescription(annotation.description());
        }
        if (annotation.alias().length != 0) {
            command.setAliases(Arrays.asList(annotation.alias()));
        }
    }
}

