/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.apache;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import simplepets.brainsynder.libs.bslib.apache.StringBuilderWriter;

public class ApacheUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static String toString(InputStream input) throws IOException {
        StringBuilderWriter sw = new StringBuilderWriter();
        ApacheUtils.copy(input, (Writer)sw);
        return sw.toString();
    }

    public static void copy(InputStream input, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        ApacheUtils.copy(in, output);
    }

    public static int copy(Reader input, Writer output) throws IOException {
        long count = ApacheUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

