/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.impl;

import com.google.common.collect.Lists;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import simplepets.brainsynder.api.entity.IEntityPet;
import simplepets.brainsynder.api.pet.CommandReason;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.plugin.utils.IPetUtilities;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.utils.Colorize;

public class PetUtility
implements IPetUtilities {
    @Override
    public void runPetCommands(CommandReason reason, PetUser owner, PetType type) {
        this.runPetCommands(reason, owner, type, null);
    }

    @Override
    public void runPetCommands(CommandReason reason, PetUser owner, PetType type, Location location) {
        SimplePets.getPetConfigManager().getPetConfig(type).ifPresent(config -> {
            List<String> commands = config.getCommands().getOrDefault((Object)reason, Lists.newArrayList());
            IEntityPet pet = owner.getPetEntity(type).orElse(null);
            commands.forEach(command -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.handleCommand(owner, pet, pet != null ? null : location, (String)command)));
        });
    }

    private String handleCommand(PetUser owner, IEntityPet entity, Location petLoc, String command) {
        String text = this.handlePlaceholders(owner, entity, petLoc, command);
        if (text == null) {
            return null;
        }
        if (text.startsWith("/")) {
            text = text.substring(1);
        }
        if (text.contains("{petName}")) {
            text = text.replace("{petName}", this.safePetName(entity));
        }
        return text;
    }

    private String safePetName(IEntityPet entity) {
        if (entity == null || entity.getPetName().isEmpty()) {
            return "Pet";
        }
        String name = ChatColor.stripColor((String)entity.getPetName().get());
        name = name.replace("\r", "").replace("\n", "").replace("\t", "");
        name = name.replaceAll("[;&|`$<>\\\\]", "").replaceAll("\\s+", "_");
        if ((name = name.replaceAll("[^A-Za-z0-9_\\-]", "_").replaceAll("_+", "_")).isBlank()) {
            name = "Pet";
        }
        if (name.length() > 32) {
            name = name.substring(0, 32);
        }
        return name;
    }

    @Override
    public String handlePlaceholders(PetUser owner, IEntityPet entity, Location petLoc, String text) {
        Location ownerLoc;
        if (text == null || owner == null) {
            return text;
        }
        Player player = owner.getPlayer();
        Location location = ownerLoc = player != null ? player.getLocation() : null;
        if (petLoc == null && entity != null && entity.getEntity() != null) {
            petLoc = entity.getEntity().getLocation();
        }
        String petType = "Unknown";
        String petUuid = "Unknown";
        String petName = "Pet";
        if (entity != null && entity.getEntity() != null) {
            PetType type = entity.getPetType();
            if (type != null) {
                petType = type.getName();
            }
            petUuid = entity.getEntity().getUniqueId().toString();
            if (entity.getPetName().isPresent()) {
                petName = entity.getPetName().get();
            }
        }
        if (petLoc != null) {
            text = text.replace("{petX}", String.valueOf(petLoc.getX())).replace("{petY}", String.valueOf(petLoc.getY())).replace("{petZ}", String.valueOf(petLoc.getZ()));
        }
        if (ownerLoc != null) {
            text = text.replace("{ownerX}", String.valueOf(ownerLoc.getX())).replace("{ownerY}", String.valueOf(ownerLoc.getY())).replace("{ownerZ}", String.valueOf(ownerLoc.getZ()));
        }
        return text.replace("{ownerName}", owner.getOwnerName()).replace("{petType}", petType).replace("{petUUID}", petUuid).replace("{petName}", petName);
    }

    @Override
    public String translatePetName(String name) {
        boolean color = ConfigOption.INSTANCE.RENAME_COLOR_ENABLED.getValue();
        boolean magic = ConfigOption.INSTANCE.RENAME_COLOR_MAGIC.getValue();
        if (!magic) {
            name = name.replace("&k", "");
        }
        if (!color) {
            return name;
        }
        name = ConfigOption.INSTANCE.RENAME_COLOR_HEX.getValue() != false ? Colorize.translateBungeeHex(name) : Colorize.translateBukkit(name);
        return name;
    }
}

