/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.ISpawnUtil;
import simplepets.brainsynder.api.entity.IEntityPet;
import simplepets.brainsynder.api.entity.misc.IEntityControllerPet;
import simplepets.brainsynder.api.event.entity.PetDismountEvent;
import simplepets.brainsynder.api.event.entity.PetDuplicateSpawnEvent;
import simplepets.brainsynder.api.event.entity.PetMountEvent;
import simplepets.brainsynder.api.event.entity.PetRemoveEvent;
import simplepets.brainsynder.api.event.entity.PostPetHatEvent;
import simplepets.brainsynder.api.event.entity.PrePetHatEvent;
import simplepets.brainsynder.api.event.user.PetNameChangeEvent;
import simplepets.brainsynder.api.other.ParticleHandler;
import simplepets.brainsynder.api.pet.CommandReason;
import simplepets.brainsynder.api.pet.IPetConfig;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.apache.Validate;
import simplepets.brainsynder.libs.bslib.nbt.StorageBase;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagList;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagString;
import simplepets.brainsynder.libs.bslib.optional.BiOptional;
import simplepets.brainsynder.managers.InventoryManager;
import simplepets.brainsynder.utils.Utilities;

public class PetOwner
implements PetUser {
    private final UUID uuid;
    private final String name;
    private boolean isLoaded = false;
    private PetType vehicle = null;
    private final List<PetType> hatPets;
    private final List<StorageTagCompound> respawnPets;
    private final List<StorageTagCompound> savedPetData;
    private final List<PetType> ownedPets;
    private final Map<PetType, IEntityPet> petMap;
    private final Map<PetType, String> nameMap;

    public PetOwner(Player player) {
        Validate.notNull(player, "Player can not be null (They Offline?)");
        this.uuid = player.getUniqueId();
        this.name = player.getName();
        this.respawnPets = new ArrayList<StorageTagCompound>();
        this.savedPetData = new ArrayList<StorageTagCompound>();
        this.hatPets = new ArrayList<PetType>();
        this.petMap = new HashMap<PetType, IEntityPet>();
        this.nameMap = new HashMap<PetType, String>();
        this.ownedPets = new ArrayList<PetType>();
    }

    public PetOwner(String username) {
        this(Bukkit.getPlayerExact((String)username));
    }

    public void loadCompound(final StorageTagCompound compound) {
        this.respawnPets.clear();
        this.savedPetData.clear();
        this.hatPets.clear();
        this.petMap.clear();
        this.nameMap.clear();
        this.ownedPets.clear();
        new BukkitRunnable(){

            public void run() {
                StorageTagList list;
                if (compound.hasKey("pet_names")) {
                    StorageTagList names = (StorageTagList)compound.getTag("pet_names");
                    names.getList().forEach(storageBase -> {
                        StorageTagCompound data = (StorageTagCompound)storageBase;
                        PetType.getPetType(data.getString("type", "unknown")).ifPresent(type -> PetOwner.this.nameMap.put((PetType)((Object)((Object)type)), data.getString("name")));
                    });
                }
                if (compound.hasKey("owned_pets")) {
                    list = (StorageTagList)compound.getTag("owned_pets");
                    list.getList().forEach(storageBase -> {
                        StorageTagString string = (StorageTagString)storageBase;
                        PetType.getPetType(string.getString()).ifPresent(PetOwner.this.ownedPets::add);
                    });
                }
                if (compound.hasKey("saved_pets")) {
                    list = (StorageTagList)compound.getTag("saved_pets");
                    list.getList().forEach(base -> {
                        StorageTagCompound tag = (StorageTagCompound)base;
                        PetType.getPetType(tag.getString("type", "unknown")).ifPresent(type -> PetOwner.this.savedPetData.add(tag.getCompoundTag("data")));
                    });
                }
                if (compound.hasKey("spawned_pets") && ConfigOption.INSTANCE.RESPAWN_LAST_PET_LOGIN.getValue().booleanValue()) {
                    list = (StorageTagList)compound.getTag("spawned_pets");
                    ISpawnUtil spawnUtil = SimplePets.getSpawnUtil();
                    list.getList().forEach(storageBase -> {
                        StorageTagCompound tag = (StorageTagCompound)storageBase;
                        PetOwner.this.respawnPets.remove(tag.getCompoundTag("data"));
                        PetType.getPetType(tag.getString("type", "unknown")).ifPresent(type -> SimplePets.getPetConfigManager().getPetConfig((PetType)((Object)((Object)type))).ifPresent(config -> {
                            if (!config.isEnabled()) {
                                return;
                            }
                            if (!type.isSupported()) {
                                return;
                            }
                            if (!spawnUtil.isRegistered((PetType)((Object)((Object)type)))) {
                                return;
                            }
                            Player player = Bukkit.getPlayer((UUID)PetOwner.this.uuid);
                            if (player != null) {
                                if (!Utilities.hasPermission((CommandSender)player, type.getPermission())) {
                                    return;
                                }
                                spawnUtil.spawnEntityPet((PetType)((Object)((Object)type)), (PetUser)PetOwner.this, tag.getCompoundTag("data"));
                            }
                        }));
                    });
                }
                PetOwner.this.isLoaded = true;
            }
        }.runTask((Plugin)PetCore.getInstance());
    }

    public StorageTagCompound toCompound() {
        StorageTagCompound compound = new StorageTagCompound();
        compound.setUniqueId("uuid", this.uuid);
        StorageTagList owned = new StorageTagList();
        this.ownedPets.forEach(type -> owned.appendTag(new StorageTagString(type.getName())));
        compound.setTag("owned_pets", owned);
        StorageTagList names = new StorageTagList();
        this.nameMap.forEach((type, s) -> {
            StorageTagCompound tag = new StorageTagCompound();
            tag.setEnum("type", (Enum)type);
            tag.setString("name", (String)s);
            names.appendTag(tag);
        });
        compound.setTag("pet_names", names);
        StorageTagList pets = new StorageTagList();
        this.respawnPets.forEach(pets::appendTag);
        compound.setTag("spawned_pets", pets);
        StorageTagList saves = new StorageTagList();
        this.savedPetData.forEach(tag -> {
            StorageTagCompound storage = new StorageTagCompound();
            storage.setTag("data", (StorageBase)tag);
            storage.setString("type", tag.getString("PetType"));
            saves.appendTag(storage);
        });
        compound.setTag("saved_pets", saves);
        return compound;
    }

    @Override
    public boolean summonCachedPets() {
        if (this.respawnPets.isEmpty()) {
            return false;
        }
        ISpawnUtil spawnUtil = SimplePets.getSpawnUtil();
        if (spawnUtil == null) {
            return false;
        }
        ArrayList laterTasks = Lists.newArrayList();
        this.respawnPets.forEach(tag -> PetType.getPetType(tag.getString("type", "unknown")).ifPresent(type -> SimplePets.getPetConfigManager().getPetConfig((PetType)((Object)((Object)type))).ifPresent(config -> {
            if (!config.isEnabled()) {
                return;
            }
            if (!type.isSupported()) {
                return;
            }
            if (!spawnUtil.isRegistered((PetType)((Object)((Object)type)))) {
                return;
            }
            Player player = Bukkit.getPlayer((UUID)this.uuid);
            if (player != null) {
                if (!Utilities.hasPermission((CommandSender)player, type.getPermission())) {
                    return;
                }
                if (this.hasPet((PetType)((Object)((Object)type)))) {
                    laterTasks.add(BiOptional.of(type, tag.getCompoundTag("data")));
                } else {
                    spawnUtil.spawnEntityPet((PetType)((Object)((Object)type)), (PetUser)this, tag.getCompoundTag("data"));
                }
            }
        })));
        if (!laterTasks.isEmpty()) {
            laterTasks.forEach(biOptional -> {
                PetType type = (PetType)((Object)((Object)biOptional.first().get()));
                StorageTagCompound compound = (StorageTagCompound)biOptional.second().get();
                this.removePet(type);
                spawnUtil.spawnEntityPet(type, (PetUser)this, compound);
            });
        }
        this.respawnPets.clear();
        return true;
    }

    @Override
    public void cacheAndRemove() {
        this.petMap.forEach((type, entityPet) -> this.respawnPets.add(new StorageTagCompound().setTag("data", entityPet.asCompound()).setString("type", type.getName())));
        if (!PetCore.getInstance().isEnabled()) {
            PetCore.getInstance().getSqlHandler().sendPlayerDataSync(this.uuid, this.name, this.toCompound());
            return;
        }
        this.updateDatabase().thenAccept(callback -> {
            this.petMap.forEach((type, entityPet) -> {
                if (!this.hasPet((PetType)((Object)((Object)type)))) {
                    return;
                }
                if (this.isPetHat((PetType)((Object)((Object)type)))) {
                    this.setPetHat((PetType)((Object)((Object)type)), false);
                }
                PetRemoveEvent event = new PetRemoveEvent(this, this.petMap.get(type));
                Bukkit.getPluginManager().callEvent((Event)event);
                Utilities.runPetCommands(CommandReason.REVOKE, this, type);
                entityPet.getEntities().forEach(entity -> {
                    SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.REMOVE, this.getPlayer(), entity.getLocation());
                    entity.remove();
                });
            });
            this.petMap.clear();
        });
    }

    public void markForRespawn() {
        this.petMap.forEach((type, entityPet) -> this.respawnPets.add(new StorageTagCompound().setTag("data", entityPet.asCompound()).setString("type", type.getName())));
        if (!PetCore.getInstance().isEnabled()) {
            PetCore.getInstance().getSqlHandler().sendPlayerDataSync(this.uuid, this.name, this.toCompound());
            return;
        }
        this.updateDatabase().thenAccept(callback -> {
            this.removePets();
            this.nameMap.clear();
            this.vehicle = null;
            this.savedPetData.clear();
            this.hatPets.clear();
            this.ownedPets.clear();
            this.petMap.clear();
            this.respawnPets.clear();
            this.isLoaded = false;
        });
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public CompletableFuture<Boolean> updateDatabase() {
        return PetCore.getInstance().getSqlHandler().sendPlayerData(this.uuid, this.name, this.toCompound());
    }

    @Override
    public UUID getOwnerUUID() {
        return this.uuid;
    }

    @Override
    public String getOwnerName() {
        return this.name;
    }

    @Override
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    @Override
    public boolean hasPetSave(StorageTagCompound compound) {
        return this.savedPetData.contains(compound);
    }

    @Override
    public void removePetSave(StorageTagCompound compound) {
        if (!this.savedPetData.contains(compound)) {
            return;
        }
        this.savedPetData.remove(compound);
        this.updateDatabase();
    }

    @Override
    public void addPetSave(StorageTagCompound compound) {
        if (this.savedPetData.contains(compound)) {
            return;
        }
        this.savedPetData.add(compound);
        this.updateDatabase();
    }

    @Override
    public List<PetUser.Entry<PetType, StorageTagCompound>> getSavedPets() {
        ArrayList entryList = Lists.newArrayList();
        this.savedPetData.forEach(compound -> PetType.getPetType(compound.getString("PetType")).ifPresent(type -> entryList.add(new PetUser.Entry<PetType, StorageTagCompound>((PetType)((Object)((Object)type)), (StorageTagCompound)compound))));
        return entryList;
    }

    @Override
    public boolean canSaveMorePets() {
        if (!ConfigOption.INSTANCE.PET_SAVES_ENABLED.getValue().booleanValue()) {
            return false;
        }
        int saveLimit = ConfigOption.INSTANCE.PET_SAVES_LIMIT.getValue();
        if (saveLimit < 0) {
            return true;
        }
        if (this.getPlayer().isOp()) {
            return true;
        }
        if (this.getPlayer().hasPermission("pet.saves.bypass")) {
            return true;
        }
        return this.savedPetData.size() < Utilities.getPermissionAmount(this.getPlayer(), saveLimit, "pet.saves.");
    }

    @Override
    public List<PetType> getOwnedPets() {
        return this.ownedPets;
    }

    @Override
    public void addOwnedPet(PetType type) {
        if (this.ownedPets.contains((Object)type)) {
            return;
        }
        this.ownedPets.add(type);
        this.updateDatabase();
    }

    @Override
    public void removeOwnedPet(PetType type) {
        this.ownedPets.remove((Object)type);
        this.updateDatabase();
    }

    @Override
    public Optional<String> getPetName(PetType type) {
        if (this.nameMap.containsKey((Object)type)) {
            return Optional.of(this.nameMap.get((Object)type));
        }
        Optional<IPetConfig> config = SimplePets.getPetConfigManager().getPetConfig(type);
        return config.map(IPetConfig::getDisplayName);
    }

    @Override
    public void setPetName(String name, PetType type) {
        if (name != null) {
            this.nameMap.put(type, name);
        }
        if (name == null) {
            Optional<IPetConfig> config = SimplePets.getPetConfigManager().getPetConfig(type);
            if (config.isPresent()) {
                name = config.get().getDisplayName();
            }
            this.nameMap.remove((Object)type);
        }
        this.updateDatabase();
        String finalName = name;
        this.getPetEntity(type).ifPresent(entity -> {
            PetNameChangeEvent event = new PetNameChangeEvent(this, (IEntityPet)entity, finalName);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            entity.setPetName(finalName);
            SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.RENAME, this.getPlayer(), entity.getEntity().getLocation());
        });
    }

    @Override
    public boolean hasPets() {
        return !this.petMap.isEmpty();
    }

    @Override
    public boolean hasPet(PetType type) {
        return this.petMap.containsKey((Object)type);
    }

    @Override
    public boolean removePet(PetType type) {
        if (!this.hasPet(type)) {
            return false;
        }
        if (this.isPetHat(type)) {
            this.setPetHat(type, false);
        }
        PetRemoveEvent event = new PetRemoveEvent(this, this.petMap.get((Object)type));
        Bukkit.getPluginManager().callEvent((Event)event);
        Utilities.runPetCommands(CommandReason.REVOKE, this, type);
        IEntityPet entityPet = this.petMap.get((Object)type);
        this.respawnPets.remove(new StorageTagCompound().setTag("data", entityPet.asCompound()).setString("type", type.getName()));
        entityPet.getEntities().forEach(entity -> {
            SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.REMOVE, this.getPlayer(), entity.getLocation());
            entity.remove();
        });
        this.petMap.remove((Object)type);
        return true;
    }

    @Override
    public boolean removePets() {
        if (this.petMap.isEmpty()) {
            return false;
        }
        this.petMap.forEach((type, entityPet) -> {
            if (this.isPetHat((PetType)((Object)type))) {
                this.setPetHat((PetType)((Object)type), false);
            }
            PetRemoveEvent event = new PetRemoveEvent(this, (IEntityPet)entityPet);
            Bukkit.getPluginManager().callEvent((Event)event);
            Utilities.runPetCommands(CommandReason.REVOKE, this, type);
            this.respawnPets.remove(new StorageTagCompound().setTag("data", entityPet.asCompound()).setString("type", type.getName()));
            entityPet.getEntities().forEach(entity -> {
                SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.REMOVE, this.getPlayer(), entity.getLocation());
                entity.remove();
            });
        });
        this.petMap.clear();
        return true;
    }

    @Override
    public Collection<IEntityPet> getPetEntities() {
        return this.petMap.values();
    }

    @Override
    public Optional<IEntityPet> getPetEntity(PetType type) {
        if (this.petMap.containsKey((Object)type)) {
            IEntityPet entityPet = this.petMap.get((Object)type);
            if (entityPet instanceof IEntityControllerPet) {
                entityPet = ((IEntityControllerPet)entityPet).getVisibleEntity();
            }
            return Optional.of(entityPet);
        }
        return Optional.empty();
    }

    @Override
    public void setPet(IEntityPet entity) {
        if (entity == null) {
            return;
        }
        if (!entity.getOwnerUUID().equals(this.uuid)) {
            return;
        }
        this.getPetEntity(entity.getPetType()).ifPresent(entityPet -> {
            PetDuplicateSpawnEvent event = new PetDuplicateSpawnEvent(this, (IEntityPet)entityPet);
            Bukkit.getPluginManager().callEvent((Event)event);
            this.removePet(entityPet.getPetType());
        });
        this.petMap.put(entity.getPetType(), entity);
        entity.getEntities().forEach(ent -> SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.SPAWN, this.getPlayer(), ent.getLocation()));
        this.getPetName(entity.getPetType()).ifPresent(entity::setPetName);
    }

    @Override
    public List<PetType> getHatPets() {
        return this.hatPets;
    }

    @Override
    public boolean hasPetHat() {
        return !this.hatPets.isEmpty();
    }

    @Override
    public boolean isPetHat(PetType type) {
        if (this.hatPets.isEmpty()) {
            return false;
        }
        if (this.getPlayer().getPassengers().isEmpty()) {
            return false;
        }
        return this.hatPets.contains((Object)type);
    }

    @Override
    public void setPetHat(final PetType type, boolean hat) {
        Validate.notNull((Object)type, "PetType can not be null");
        if (!this.hasPet(type)) {
            return;
        }
        int d = 1;
        if (this.isPetVehicle(type)) {
            this.setPetVehicle(type, false);
            d = 3;
        }
        int delay = d;
        this.getPetEntity(type).ifPresent(entityPet -> {
            IPetConfig config;
            Optional<Entity> optional;
            Optional<IPetConfig> configOptional = SimplePets.getPetConfigManager().getPetConfig(type);
            if (!configOptional.isPresent()) {
                return;
            }
            Entity ent = entityPet.getEntity();
            if (entityPet instanceof IEntityControllerPet && (optional = ((IEntityControllerPet)entityPet).getDisplayEntity()).isPresent()) {
                ent = optional.get();
            }
            if ((config = configOptional.get()).canHat(this.getPlayer()) && hat) {
                PrePetHatEvent event = new PrePetHatEvent(this, (IEntityPet)entityPet, PrePetHatEvent.Type.SET);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    Utilities.runPetCommands(CommandReason.FAILED, this, type);
                    SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.TASK_FAILED, this.getPlayer(), ent.getLocation());
                    return;
                }
                this.hatPets.add(type);
                PostPetHatEvent hatEvent = new PostPetHatEvent(this, (IEntityPet)entityPet, PostPetHatEvent.Type.SET);
                Bukkit.getPluginManager().callEvent((Event)hatEvent);
                final Entity finalEnt = ent;
                new BukkitRunnable((IEntityPet)entityPet, hat){
                    final /* synthetic */ IEntityPet val$entityPet;
                    final /* synthetic */ boolean val$hat;
                    {
                        this.val$entityPet = iEntityPet;
                        this.val$hat = bl;
                    }

                    public void run() {
                        Utilities.runPetCommands(CommandReason.HAT, PetOwner.this, type);
                        Utilities.setPassenger(PetOwner.this.getPlayer(), PetOwner.this.getTopEntity(PetOwner.this.getPlayer()), finalEnt);
                        this.val$entityPet.togglePetHatTask(this.val$hat);
                    }
                }.runTaskLater((Plugin)PetCore.getInstance(), (long)delay);
            } else {
                if (!this.isPetHat(type)) {
                    return;
                }
                PrePetHatEvent event = new PrePetHatEvent(this, (IEntityPet)entityPet, PrePetHatEvent.Type.REMOVE);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    Utilities.runPetCommands(CommandReason.FAILED, this, type);
                    SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.TASK_FAILED, this.getPlayer(), ent.getLocation());
                    return;
                }
                Entity vehicle = ent.getVehicle();
                Entity riderMob = this.getRiderEntity(ent);
                this.hatPets.remove((Object)type);
                PostPetHatEvent hatEvent = new PostPetHatEvent(this, (IEntityPet)entityPet, PostPetHatEvent.Type.REMOVE);
                Bukkit.getPluginManager().callEvent((Event)hatEvent);
                if (entityPet instanceof IEntityControllerPet) {
                    IEntityControllerPet controller = (IEntityControllerPet)entityPet;
                    Optional<Entity> riderOptional = controller.getDisplayRider();
                    if (riderOptional.isPresent()) {
                        Entity rider = riderOptional.get();
                        vehicle.eject();
                        controller.getDisplayEntity().ifPresent(entity -> {
                            Utilities.resetRideCooldown(rider);
                            entity.setPassenger(rider);
                        });
                    } else {
                        Utilities.removePassenger(vehicle, ent);
                    }
                } else {
                    Utilities.removePassenger(vehicle, ent);
                }
                entityPet.togglePetHatTask(hat);
                entityPet.teleportToOwner();
                if (riderMob != null) {
                    Utilities.setPassenger(this.getPlayer(), vehicle, riderMob);
                }
                Utilities.runPetCommands(CommandReason.HAT, this, type);
            }
        });
    }

    public Entity getTopEntity(Player player) {
        if (player.getPassengers().isEmpty()) {
            return player;
        }
        Entity entity = (Entity)player.getPassengers().get(0);
        while (!entity.getPassengers().isEmpty()) {
            entity = (Entity)entity.getPassengers().get(0);
        }
        return entity;
    }

    public Entity getRiderEntity(Entity entity) {
        if (entity.getPassengers().isEmpty()) {
            return null;
        }
        return (Entity)entity.getPassengers().get(0);
    }

    @Override
    public boolean hasPetVehicle() {
        return this.vehicle != null && this.getPetEntity(this.vehicle).isPresent();
    }

    @Override
    public boolean canSpawnMorePets() {
        int maxAmount = ConfigOption.INSTANCE.PET_TOGGLES_SPAWN_LIMIT.getValue();
        if (!this.getPlayer().isOnline()) {
            return false;
        }
        if (this.getPlayer().isOp()) {
            return true;
        }
        if (this.getPlayer().hasPermission("pet.amount.bypass")) {
            return true;
        }
        return this.petMap.size() < Utilities.getPermissionAmount(this.getPlayer(), maxAmount, "pet.amount.");
    }

    @Override
    public boolean isPetVehicle(PetType type) {
        if (this.getPlayer().getVehicle() == null) {
            this.vehicle = null;
            return false;
        }
        return this.vehicle == type;
    }

    @Override
    public boolean setPetVehicle(PetType type, boolean vehicle) {
        if (!this.hasPet(type)) {
            if (this.vehicle == type) {
                this.vehicle = null;
            }
            return false;
        }
        Player player = this.getPlayer();
        if (type == PetType.CREAKING) {
            player.sendMessage("\u00a7cRiding the Creaking Pet is disabled due to Mojang -.-\n\u00a7cPlease see:\n\u00a77https://tiny.bsdevelopment.org/creaking-ride-issue\n");
            return false;
        }
        if (this.hasPetVehicle() && player.getVehicle() != null) {
            this.getPetEntity(this.vehicle).ifPresent(entityPet -> {
                PetDismountEvent event = new PetDismountEvent((IEntityPet)entityPet);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    Utilities.runPetCommands(CommandReason.FAILED, this, type);
                    SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.FAILED, player, entityPet.getEntity().getLocation());
                    return;
                }
                if (entityPet.getEntity().getPassenger() != null) {
                    if (entityPet instanceof IEntityControllerPet) {
                        ((IEntityControllerPet)entityPet).getDisplayEntity().ifPresent(Entity::eject);
                    } else {
                        entityPet.getEntity().eject();
                    }
                }
            });
        }
        if (!vehicle) {
            return true;
        }
        this.vehicle = type;
        Optional<IPetConfig> configOptional = SimplePets.getPetConfigManager().getPetConfig(type);
        if (!configOptional.isPresent()) {
            return false;
        }
        IPetConfig config = configOptional.get();
        this.getPetEntity(type).ifPresent(entityPet -> {
            if (!config.canMount(this.getPlayer())) {
                Utilities.runPetCommands(CommandReason.FAILED, this, type);
                SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.FAILED, player, entityPet.getEntity().getLocation());
                return;
            }
            PetMountEvent event = new PetMountEvent((IEntityPet)entityPet);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                Utilities.runPetCommands(CommandReason.FAILED, this, type);
                SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.FAILED, player, entityPet.getEntity().getLocation());
                return;
            }
            if (player.getLocation().getBlock() != null) {
                List<Material> blocks = Utilities.getBlacklistedMaterials();
                if (!blocks.contains(player.getLocation().getBlock().getType()) && !blocks.contains(player.getEyeLocation().getBlock().getType())) {
                    entityPet.teleportToOwner();
                }
            } else {
                entityPet.teleportToOwner();
            }
            new BukkitRunnable(this, (IEntityPet)entityPet){
                final /* synthetic */ IEntityPet val$entityPet;
                {
                    this.val$entityPet = iEntityPet;
                }

                public void run() {
                    this.val$entityPet.attachOwner();
                }
            }.runTaskLater((Plugin)PetCore.getInstance(), 2L);
        });
        return false;
    }

    @Override
    public void updateDataMenu() {
        InventoryManager.PET_DATA.update(this);
    }

    @Override
    public void updateSelectionMenu() {
        InventoryManager.SELECTION.update(this);
    }
}

