/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.impl;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.pet.CommandReason;
import simplepets.brainsynder.api.pet.IPetConfig;
import simplepets.brainsynder.api.pet.PetConfigManager;
import simplepets.brainsynder.api.pet.PetData;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.pet.annotations.DisableDefault;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.libs.bslib.apache.WordUtils;
import simplepets.brainsynder.libs.bslib.files.JsonFile;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;
import simplepets.brainsynder.libs.bslib.json.JsonArray;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagTools;
import simplepets.brainsynder.libs.bslib.sounds.SoundMaker;
import simplepets.brainsynder.libs.bslib.utils.Capitalise;
import simplepets.brainsynder.utils.Keys;
import simplepets.brainsynder.utils.Utilities;

public class PetConfiguration
implements PetConfigManager {
    private final PetCore plugin;
    private final Map<PetType, IPetConfig> configMap;

    public PetConfiguration(PetCore plugin) {
        this.plugin = plugin;
        this.configMap = new HashMap<PetType, IPetConfig>();
        for (PetType type : PetType.values()) {
            if (!type.isSupported() || !SimplePets.getSpawnUtil().isRegistered(type)) continue;
            this.configMap.put(type, new PetConfig(this, type));
        }
    }

    public void reset() {
        this.configMap.clear();
        for (PetType type : PetType.values()) {
            if (!type.isSupported() || !SimplePets.getSpawnUtil().isRegistered(type)) continue;
            this.configMap.put(type, new PetConfig(this, type));
        }
    }

    public void reset(PetType type) {
        this.configMap.remove((Object)type);
        if (!type.isSupported()) {
            return;
        }
        if (!SimplePets.getSpawnUtil().isRegistered(type)) {
            return;
        }
        this.configMap.put(type, new PetConfig(this, type));
    }

    @Override
    public Optional<IPetConfig> getPetConfig(PetType type) {
        if (this.configMap.containsKey((Object)type)) {
            return Optional.of(this.configMap.get((Object)type));
        }
        return Optional.empty();
    }

    public class PetConfig
    implements IPetConfig {
        private final PetType type;
        private final JsonFile JSON;
        private final Map<String, JsonObject> additional;
        private final Map<CommandReason, List<String>> commandMap;

        private PetConfig(final PetConfiguration this$0, final PetType type) {
            this.type = type;
            this.additional = new HashMap<String, JsonObject>();
            this.commandMap = new HashMap<CommandReason, List<String>>();
            this.JSON = new JsonFile(new File(new File(String.valueOf(this$0.plugin.getDataFolder()) + File.separator + "Pets"), type.getName() + ".json"), true){

                @Override
                public void loadDefaults() {
                    this.setDefault("enabled", true);
                    this.setDefault("hat", true);
                    this.setDefault("mount", true);
                    type.getCustomization().ifPresent(customization -> this.setDefault("ambient-sound", customization.ambient().name()));
                    JsonObject reasons = new JsonObject();
                    for (CommandReason reason : CommandReason.values()) {
                        reasons.add(reason.name(), new JsonArray());
                    }
                    this.setDefault("commands", reasons);
                    this.setDefault("ride_speed", ConfigOption.INSTANCE.PET_TOGGLES_RIDE_SPEED.getValue());
                    this.setDefault("walk_speed", ConfigOption.INSTANCE.PET_TOGGLES_WALK_SPEED.getValue());
                    this.setDefault("fly_speed", ConfigOption.INSTANCE.PET_TOGGLES_FLY_SPEED.getValue());
                    this.setDefault("fly", PetConfig.this.canFlyDefault(type));
                    this.setDefault("float_down", false);
                    this.setDefault("display_name", "&a&l%player%'s " + Capitalise.capitalize(type.getName().replace("_", " ")) + " Pet");
                    this.setDefault("item", StorageTagTools.toJsonObject(type.getBuilder().toCompound()));
                    JsonObject dataObject = new JsonObject();
                    type.getPetData().forEach(petData -> {
                        JsonObject data = new JsonObject();
                        data.set("enabled", !petData.getClass().isAnnotationPresent(DisableDefault.class));
                        PetConfig.this.setJsonDefaultValue(data, "default", petData.getDefaultValue());
                        JsonObject values = new JsonObject();
                        petData.getDefaultItems().forEach((value, item) -> {
                            String name = petData.getNamespace().namespace();
                            name = name.replace("_", " ");
                            name = WordUtils.capitalize(name);
                            ItemBuilder builder = (ItemBuilder)item;
                            String raw = builder.getName();
                            raw = raw.replace("{name}", name);
                            builder.withName(raw);
                            values.add(String.valueOf(value), StorageTagTools.toJsonObject(builder.toCompound()));
                        });
                        data.set("values", values);
                        dataObject.add(petData.getNamespace().namespace(), data);
                    });
                    this.setDefault("data", dataObject);
                }
            };
            if (this.JSON.hasKey("commands")) {
                JsonObject commands = (JsonObject)this.JSON.getValue("commands");
                commands.names().forEach(s -> CommandReason.getReason(s).ifPresent(reason -> {
                    List<String> list = this.commandMap.getOrDefault(reason, Lists.newArrayList());
                    JsonArray array = (JsonArray)commands.get((String)s);
                    array.forEach(jsonValue -> list.add(jsonValue.asString()));
                    this.commandMap.put((CommandReason)((Object)((Object)reason)), list);
                }));
            }
            type.getPetData().forEach(this::checkPetData);
        }

        public JsonFile getJSON() {
            return this.JSON;
        }

        @Override
        public void handleAdditionalStorage(String pluginKey, Function<JsonObject, JsonObject> json) {
            this.additional.put(pluginKey, json.apply(this.additional.getOrDefault(pluginKey, new JsonObject())));
        }

        @Override
        public String getDisplayName() {
            return this.JSON.getString("display_name");
        }

        @Override
        public boolean canHat(Player player) {
            if (ConfigOption.INSTANCE.PET_TOGGLES_HAT.getValue().booleanValue()) {
                return true;
            }
            if (this.JSON.getBoolean("hat", true)) {
                return Utilities.hasPermission((CommandSender)player, this.type.getPermission("hat"));
            }
            return false;
        }

        @Override
        public boolean canMount(Player player) {
            if (ConfigOption.INSTANCE.PET_TOGGLES_MOUNTABLE.getValue().booleanValue()) {
                return true;
            }
            if (this.JSON.getBoolean("mount", true)) {
                return Utilities.hasPermission((CommandSender)player, this.type.getPermission("mount"));
            }
            return false;
        }

        @Override
        public boolean canFly(Player player) {
            if (ConfigOption.INSTANCE.PET_TOGGLES_FLYABLE.getValue().booleanValue()) {
                return true;
            }
            if (this.JSON.getBoolean("fly", true)) {
                return Utilities.hasPermission((CommandSender)player, this.type.getPermission("fly"));
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            return this.JSON.getBoolean("enabled");
        }

        @Override
        public boolean canFloat() {
            return this.JSON.getBoolean("float_down", false);
        }

        @Override
        public double getRideSpeed() {
            return this.JSON.getDouble("ride_speed", ConfigOption.INSTANCE.PET_TOGGLES_RIDE_SPEED.getValue());
        }

        @Override
        public double getWalkSpeed() {
            return this.JSON.getDouble("walk_speed", ConfigOption.INSTANCE.PET_TOGGLES_WALK_SPEED.getValue());
        }

        @Override
        public double getFlySpeed() {
            return this.JSON.getDouble("fly_speed", ConfigOption.INSTANCE.PET_TOGGLES_FLY_SPEED.getValue());
        }

        @Override
        public Optional<EntityType> getEntityType() {
            return Optional.empty();
        }

        @Override
        public SoundMaker getSound() {
            if (!this.JSON.containsKey("ambient-sound")) {
                return null;
            }
            String sound = this.JSON.getString("ambient-sound", null);
            if (sound == null) {
                return null;
            }
            return SoundMaker.fromString(sound);
        }

        @Override
        public ItemBuilder getBuilder() {
            try {
                return ItemBuilder.fromCompound(StorageTagTools.fromJsonObject((JsonObject)this.JSON.getValue("item"))).handleMeta(ItemMeta.class, itemMeta -> {
                    itemMeta.getPersistentDataContainer().set(Keys.GUI_ITEM, PersistentDataType.INTEGER, (Object)1);
                    itemMeta.getPersistentDataContainer().set(Keys.PET_TYPE_ITEM, PersistentDataType.STRING, (Object)this.type.getName());
                    return itemMeta;
                });
            }
            catch (Exception e) {
                SimplePets.getDebugLogger().debug(DebugLevel.ERROR, "Failed to get default item for '" + this.type.getName() + "'");
                SimplePets.getDebugLogger().debug(DebugLevel.ERROR, "Error: " + e.getMessage());
                return this.type.getBuilder();
            }
        }

        @Override
        public Optional<ItemBuilder> getDataItem(String namespace, Object value) {
            return this.getDataItem(namespace, value, null, false);
        }

        @Override
        public Optional<ItemBuilder> getDataItem(String namespace, Object value, ItemBuilder fallback) {
            return this.getDataItem(namespace, value, fallback, true);
        }

        private Optional<ItemBuilder> getDataItem(String namespace, Object value, ItemBuilder fallback, boolean allowInsertFallback) {
            if (!this.JSON.containsKey("data")) {
                return Optional.empty();
            }
            JsonObject dataRoot = (JsonObject)this.JSON.getValue("data");
            if (!dataRoot.names().contains(namespace)) {
                return Optional.empty();
            }
            JsonObject dataSection = (JsonObject)dataRoot.get(namespace);
            JsonObject values = this.ensureValuesObject(dataRoot, namespace, dataSection, true);
            String key = String.valueOf(value);
            if (values.names().contains(key)) {
                return Optional.of(ItemBuilder.fromCompound(StorageTagTools.fromJsonObject((JsonObject)values.get(key))));
            }
            if (fallback == null) {
                return Optional.empty();
            }
            if (allowInsertFallback) {
                values.add(key, StorageTagTools.toJsonObject(fallback.toCompound()));
                dataSection.set("values", values);
                dataRoot.add(namespace, dataSection);
                this.JSON.set("data", dataRoot);
                this.JSON.save(true);
                return Optional.of(fallback);
            }
            return Optional.of(fallback);
        }

        @Override
        public JsonObject getRawData(String namespace) {
            JsonObject dataObject;
            JsonObject data = new JsonObject();
            if (this.JSON.containsKey("data") && (dataObject = (JsonObject)this.JSON.getValue("data")).names().contains(namespace)) {
                data = (JsonObject)dataObject.get(namespace);
            }
            return data;
        }

        @Override
        public Map<CommandReason, List<String>> getCommands() {
            return this.commandMap;
        }

        private boolean checkPetData(PetData petData) {
            JsonObject values;
            boolean expectedEnabledDefault;
            String namespace = petData.getNamespace().namespace();
            JsonObject dataRoot = this.ensureDataRoot(false);
            JsonObject section = dataRoot.names().contains(namespace) ? (JsonObject)dataRoot.get(namespace) : new JsonObject();
            boolean changed = false;
            boolean bl = expectedEnabledDefault = !petData.getClass().isAnnotationPresent(DisableDefault.class);
            if (!section.names().contains("enabled")) {
                section.set("enabled", expectedEnabledDefault);
                changed = true;
            }
            if (!section.names().contains("default")) {
                this.setJsonDefaultValue(section, "default", petData.getDefaultValue());
                changed = true;
            }
            JsonObject jsonObject = values = section.names().contains("values") ? (JsonObject)section.get("values") : new JsonObject();
            if (values.names().isEmpty()) {
                petData.getDefaultItems().forEach((val, item) -> values.add(String.valueOf(val), StorageTagTools.toJsonObject(((ItemBuilder)item).toCompound())));
                changed = true;
            } else {
                Iterator<Map.Entry<String, ItemBuilder>> iterator = petData.getDefaultItems().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ItemBuilder> object;
                    Map.Entry<String, ItemBuilder> entry = object = iterator.next();
                    String key = String.valueOf(entry.getKey());
                    if (values.names().contains(key)) continue;
                    values.add(key, StorageTagTools.toJsonObject(entry.getValue().toCompound()));
                    changed = true;
                }
            }
            section.set("values", values);
            dataRoot.add(namespace, section);
            if (changed) {
                this.JSON.set("data", dataRoot);
                this.JSON.save(true);
                return false;
            }
            return true;
        }

        private JsonObject ensureDataRoot(boolean save) {
            if (!this.JSON.containsKey("data")) {
                SimplePets.getDebugLogger().debug(DebugLevel.DEBUG, this.type.getName() + " | Missing 'data' section");
                JsonObject root = new JsonObject();
                this.JSON.set("data", root);
                if (save) {
                    this.JSON.save(true);
                }
                return root;
            }
            return (JsonObject)this.JSON.getValue("data");
        }

        private JsonObject ensureValuesObject(JsonObject dataRoot, String namespace, JsonObject section, boolean save) {
            JsonObject values;
            JsonObject jsonObject = values = section.names().contains("values") ? (JsonObject)section.get("values") : new JsonObject();
            if (values.names().isEmpty()) {
                for (PetData petData : this.type.getPetData()) {
                    if (!petData.getNamespace().namespace().equals(namespace)) continue;
                    petData.getDefaultItems().forEach((val, item) -> values.add(String.valueOf(val), StorageTagTools.toJsonObject(((ItemBuilder)item).toCompound())));
                    if (!section.names().contains("default")) {
                        this.setJsonDefaultValue(section, "default", petData.getDefaultValue());
                    }
                    if (section.names().contains("enabled")) break;
                    section.set("enabled", !petData.getClass().isAnnotationPresent(DisableDefault.class));
                    break;
                }
                section.set("values", values);
                dataRoot.add(namespace, section);
                this.JSON.set("data", dataRoot);
                if (save) {
                    this.JSON.save(true);
                }
            }
            return values;
        }

        private void setJsonDefaultValue(JsonObject obj, String key, Object value) {
            if (value instanceof Integer) {
                Integer i = (Integer)value;
                obj.set(key, i);
                return;
            }
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                obj.set(key, b);
                return;
            }
            if (value instanceof Double) {
                Double d = (Double)value;
                obj.set(key, d);
                return;
            }
            if (value instanceof Float) {
                Float f = (Float)value;
                obj.set(key, f.doubleValue());
                return;
            }
            obj.set(key, String.valueOf(value));
        }

        private boolean canFlyDefault(PetType type) {
            return type == PetType.BAT || type == PetType.BEE || type == PetType.BLAZE || type == PetType.PHANTOM || type == PetType.PARROT || type == PetType.GHAST || type == PetType.VEX || type == PetType.WITHER;
        }
    }
}

