/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.debug;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;

public class DebugLevel {
    public static final DebugLevel DEBUG;
    public static final DebugLevel HIDDEN;
    public static final DebugLevel NORMAL;
    public static final DebugLevel WARNING;
    public static final DebugLevel ERROR;
    public static final DebugLevel CRITICAL;
    public static final DebugLevel UPDATE;
    private static final List<DebugLevel> levels;
    private String levelName = null;
    private final String name;
    private final ChatColor textColor;
    private final ChatColor prefixColor;
    private boolean bypassDisable = false;
    private boolean hidden = false;

    public DebugLevel(ChatColor textColor) {
        this("Debug", textColor);
    }

    public DebugLevel(ChatColor textColor, ChatColor prefixColor) {
        this("Debug", textColor, prefixColor);
    }

    public DebugLevel(String name, ChatColor textColor) {
        this(name, textColor, ChatColor.GOLD);
    }

    public DebugLevel(String name, ChatColor textColor, ChatColor prefixColor) {
        this.name = name;
        this.textColor = textColor;
        this.prefixColor = prefixColor;
        levels.add(this);
    }

    public static List<String> getLevels() {
        ArrayList<String> list = new ArrayList<String>();
        for (DebugLevel level : levels) {
            if (level == DEBUG || level == UPDATE || level == HIDDEN) continue;
            list.add(level.getName());
        }
        return list;
    }

    public ChatColor getTextColor() {
        return this.textColor;
    }

    public ChatColor getPrefixColor() {
        return this.prefixColor;
    }

    public String getName() {
        return this.name;
    }

    public DebugLevel setBypassDisable(boolean bypassDisable) {
        this.bypassDisable = bypassDisable;
        return this;
    }

    public DebugLevel setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public DebugLevel setLevelName(String levelName) {
        this.levelName = levelName;
        return this;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean canBypassDisable() {
        return this.bypassDisable;
    }

    static {
        levels = Lists.newArrayList();
        DEBUG = new DebugLevel(ChatColor.WHITE, ChatColor.AQUA).setBypassDisable(true);
        HIDDEN = new DebugLevel(ChatColor.WHITE, ChatColor.GRAY).setBypassDisable(true).setHidden(true);
        NORMAL = new DebugLevel(ChatColor.WHITE).setLevelName("NORMAL");
        WARNING = new DebugLevel("Warning", ChatColor.YELLOW).setLevelName("WARNING");
        ERROR = new DebugLevel("Error", ChatColor.RED).setLevelName("ERROR");
        CRITICAL = new DebugLevel("Critical Error", ChatColor.WHITE, ChatColor.RED).setBypassDisable(true);
        UPDATE = new DebugLevel("Update", ChatColor.GRAY, ChatColor.GREEN).setBypassDisable(true);
    }
}

