/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.debug;

import com.google.common.collect.Lists;
import java.util.List;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.libs.bslib.utils.AdvString;

public class DebugBuilder {
    public long timestamp;
    private boolean broadcast = false;
    private boolean sync = false;
    private DebugLevel level;
    private List<String> messages;
    private final String caller;
    private final Class<?> clazz;

    private DebugBuilder() {
        this(null);
    }

    private DebugBuilder(Class<?> clazz) {
        this.clazz = clazz;
        this.timestamp = System.currentTimeMillis();
        this.level = DebugLevel.NORMAL;
        this.messages = Lists.newArrayList();
        this.caller = this.getCallerData();
    }

    public DebugBuilder setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
        return this;
    }

    public DebugBuilder setLevel(DebugLevel level) {
        this.level = level;
        return this;
    }

    public DebugBuilder setMessages(String ... messages) {
        this.messages = Lists.newArrayList((Object[])messages);
        return this;
    }

    public DebugBuilder setSync(boolean sync) {
        this.sync = sync;
        return this;
    }

    public DebugLevel getLevel() {
        return this.level;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getCaller() {
        return this.caller;
    }

    private String getCallerData() {
        String callerClassName = null;
        try {
            throw new Exception("Fetching location");
        }
        catch (Exception exception) {
            for (StackTraceElement element : exception.getStackTrace()) {
                String name = element.getClassName();
                if (name == null || name.contains("Thread") || name.toLowerCase().contains("debug") || !name.contains("simplepets") || this.clazz != null && !name.contains(this.clazz.getName())) continue;
                String method = element.getMethodName();
                if (method.contains("$")) {
                    method = AdvString.after("$", method);
                }
                method = method.replace("$1", "");
                callerClassName = AdvString.afterLast(".", name).replace("$1", "") + "(method: " + method + "() | line: " + element.getLineNumber() + ")";
            }
            return callerClassName;
        }
    }

    public String getCallerClassName() {
        String callerClassName = null;
        try {
            throw new Exception("Fetching location");
        }
        catch (Exception exception) {
            for (StackTraceElement element : exception.getStackTrace()) {
                String name = element.getClassName();
                if (name == null || name.contains("Thread") || name.toLowerCase().contains("debug") || !name.contains("simplepets") || this.clazz != null && !name.contains(this.clazz.getName())) continue;
                callerClassName = AdvString.afterLast(".", name).replace("$1", "");
            }
            return callerClassName;
        }
    }

    public boolean broadcast() {
        return this.broadcast;
    }

    public boolean sync() {
        return this.sync;
    }

    public static DebugBuilder build() {
        return DebugBuilder.build(null);
    }

    public static DebugBuilder build(Class<?> clazz) {
        return new DebugBuilder(clazz);
    }
}

