/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.commands.list;

import com.google.common.collect.Lists;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.commands.Permission;
import simplepets.brainsynder.commands.PetSubCommand;
import simplepets.brainsynder.files.MessageFile;
import simplepets.brainsynder.files.options.MessageOption;
import simplepets.brainsynder.libs.bslib.commands.annotations.ICommand;
import simplepets.brainsynder.libs.bslib.nms.Tellraw;

@ICommand(name="purchased", usage="<add/remove/list> <player> [type]", description="Controls what pets the player has purchased")
@Permission(permission="purchased", adminCommand=true, additionalPermissions={"add", "remove", "list", "list.other"})
public class PurchasedCommand
extends PetSubCommand {
    public PurchasedCommand(PetCore plugin) {
        super(plugin);
    }

    @Override
    public List<String> handleCompletions(List<String> completions, CommandSender sender, int index, String[] args) {
        if (args.length == 1) {
            if (sender.hasPermission(this.getPermission("add"))) {
                completions.add("add");
            }
            if (sender.hasPermission(this.getPermission("remove"))) {
                completions.add("remove");
            }
            if (sender.hasPermission(this.getPermission("list"))) {
                completions.add("list");
            }
            return completions;
        }
        if (args.length == 2) {
            if (args[0].contains("list")) {
                if (sender.hasPermission(this.getPermission("list.other"))) {
                    return this.getOnlinePlayers();
                }
                return Lists.newArrayList((Object[])new String[]{sender.getName()});
            }
            return completions;
        }
        if (index == 3 && !args[0].contains("list")) {
            return this.getPetTypes();
        }
        return super.handleCompletions(completions, sender, index, args);
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        if (args.length == 0) {
            this.sendUsage(sender);
            return;
        }
        if (args.length == 1) {
            this.sendUsage(sender);
            return;
        }
        Player target = Bukkit.getPlayerExact((String)args[1]);
        if (args[0].equalsIgnoreCase("list") && !sender.hasPermission(this.getPermission("list.other")) && sender instanceof Player) {
            target = (Player)sender;
        }
        if (target == null) {
            sender.sendMessage(MessageFile.getTranslation(MessageOption.PLAYER_NOT_ONLINE));
            return;
        }
        Player finalTarget = target;
        SimplePets.getUserManager().getPetUser(target).ifPresent(user -> {
            if (args[0].equalsIgnoreCase("add")) {
                if (!sender.hasPermission(this.getPermission("add"))) {
                    sender.sendMessage(MessageFile.getTranslation(MessageOption.NO_PERMISSION));
                    return;
                }
                if (args.length == 2) {
                    sender.sendMessage(MessageFile.getTranslation(MessageOption.MISSING_PET_TYPE));
                    return;
                }
                PetType.getPetType(args[2]).ifPresent(type -> {
                    user.addOwnedPet((PetType)((Object)((Object)type)));
                    sender.sendMessage(MessageFile.getTranslation(MessageOption.PURCHASE_ADD).replace("{player}", finalTarget.getName()).replace("{type}", type.getName()));
                });
                return;
            }
            if (args[0].equalsIgnoreCase("remove")) {
                if (!sender.hasPermission(this.getPermission("remove"))) {
                    sender.sendMessage(MessageFile.getTranslation(MessageOption.NO_PERMISSION));
                    return;
                }
                if (args.length == 2) {
                    sender.sendMessage(MessageFile.getTranslation(MessageOption.MISSING_PET_TYPE));
                    return;
                }
                PetType.getPetType(args[2]).ifPresent(type -> {
                    user.removeOwnedPet((PetType)((Object)((Object)type)));
                    sender.sendMessage(MessageFile.getTranslation(MessageOption.PURCHASE_REMOVE).replace("{player}", finalTarget.getName()).replace("{type}", type.getName()));
                });
                return;
            }
            if (args[0].equalsIgnoreCase("list")) {
                if (!sender.hasPermission(this.getPermission("list"))) {
                    sender.sendMessage(MessageFile.getTranslation(MessageOption.NO_PERMISSION));
                    return;
                }
                Object prefix = MessageFile.getTranslation(MessageOption.PURCHASE_LIST_PREFIX);
                if (!((String)prefix).endsWith(" ")) {
                    prefix = (String)prefix + " ";
                }
                Tellraw tellraw = Tellraw.getInstance((String)prefix);
                user.getOwnedPets().forEach(type -> tellraw.then(type.getName()).color(ChatColor.GREEN).then(", ").color(ChatColor.of((String)"#d1c9c9")));
                tellraw.removeLastPart();
                tellraw.send(sender);
                return;
            }
            this.sendUsage(sender);
        });
    }
}

