/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.commands.list;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.commands.Permission;
import simplepets.brainsynder.commands.PetSubCommand;
import simplepets.brainsynder.commands.PetsCommand;
import simplepets.brainsynder.libs.bslib.commands.annotations.ICommand;
import simplepets.brainsynder.libs.bslib.utils.Colorize;

@ICommand(name="help", description="Lists all the commands for the plugin")
@Permission(permission="help", defaultAllow=true)
public class HelpCommand
extends PetSubCommand {
    private final PetsCommand parent;

    public HelpCommand(PetsCommand parent) {
        super(parent.getPlugin());
        this.parent = parent;
    }

    @Override
    public void run(CommandSender sender) {
        ArrayList adminCommands = Lists.newArrayList();
        this.parent.getSubCommands().forEach(sub -> {
            if (sub.getClass().isAnnotationPresent(Permission.class)) {
                Permission permission = sub.getClass().getAnnotation(Permission.class);
                if (permission.adminCommand() && sender.hasPermission(permission.permission())) {
                    adminCommands.add(sub);
                    return;
                }
                if (!permission.defaultAllow() && !sender.hasPermission(permission.permission())) {
                    return;
                }
                if (ConfigOption.INSTANCE.MISC_TOGGLES_IGNORE_ALLOWS_DEFAULT.getValue().booleanValue() && !sender.hasPermission(permission.permission())) {
                    return;
                }
            }
            sub.sendUsage(sender);
        });
        if (adminCommands.isEmpty()) {
            return;
        }
        sender.sendMessage(ChatColor.RESET.toString());
        sender.sendMessage(Colorize.translateBungeeHex("&r &r &#e1eb5b[] &#d1c9c9----- &#b35349&lADMIN COMMANDS&r&#d1c9c9 ----- &#e1eb5b[]"));
        adminCommands.forEach(petSubCommand -> petSubCommand.sendUsage(sender));
    }
}

