/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.commands;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.commands.Permission;
import simplepets.brainsynder.commands.PetSubCommand;
import simplepets.brainsynder.commands.list.AddonCommand;
import simplepets.brainsynder.commands.list.DataCommand;
import simplepets.brainsynder.commands.list.DatabaseCommand;
import simplepets.brainsynder.commands.list.DebugCommand;
import simplepets.brainsynder.commands.list.GUICommand;
import simplepets.brainsynder.commands.list.HelpCommand;
import simplepets.brainsynder.commands.list.ListCommand;
import simplepets.brainsynder.commands.list.ModifyCommand;
import simplepets.brainsynder.commands.list.PermissionsCommand;
import simplepets.brainsynder.commands.list.PetConfigCommand;
import simplepets.brainsynder.commands.list.PremiumCommand;
import simplepets.brainsynder.commands.list.PurchasedCommand;
import simplepets.brainsynder.commands.list.RegenerateCommand;
import simplepets.brainsynder.commands.list.ReloadCommand;
import simplepets.brainsynder.commands.list.RemoveCommand;
import simplepets.brainsynder.commands.list.RenameCommand;
import simplepets.brainsynder.commands.list.SummonCommand;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.libs.bslib.commands.ParentCommand;
import simplepets.brainsynder.libs.bslib.commands.annotations.ICommand;
import simplepets.brainsynder.libs.bslib.utils.Colorize;
import simplepets.brainsynder.utils.Premium;

@ICommand(name="pet", alias={"pets", "simplepets", "simplepet"}, description="Main SimplePets Command/Opens The Pet Selection GUI")
public class PetsCommand
extends ParentCommand<PetSubCommand> {
    private final PetCore plugin;

    public PetsCommand(PetCore plugin) {
        this.plugin = plugin;
        this.registerSub(new HelpCommand(this));
        this.registerSub(new SummonCommand(plugin));
        this.registerSub(new ModifyCommand(plugin));
        this.registerSub(new RemoveCommand(plugin));
        this.registerSub(new ListCommand(plugin));
        this.registerSub(new GUICommand(plugin));
        this.registerSub(new DataCommand(plugin));
        if (ConfigOption.INSTANCE.RENAME_ENABLED.getValue().booleanValue()) {
            this.registerSub(new RenameCommand(plugin));
        }
        this.registerSub(new PurchasedCommand(plugin));
        this.registerSub(new PermissionsCommand(this));
        this.registerSub(new RegenerateCommand(plugin));
        this.registerSub(new DebugCommand(this));
        this.registerSub(new AddonCommand(plugin));
        this.registerSub(new DatabaseCommand(plugin));
        this.registerSub(new ReloadCommand(plugin));
        this.registerSub(new PetConfigCommand(plugin));
        if (Premium.isPremium()) {
            this.registerSub(new PremiumCommand(plugin));
        }
    }

    @Override
    protected void registerSub(PetSubCommand subCommand) {
        SimplePets.getDebugLogger().debug(DebugLevel.HIDDEN, "- Registering sub-command: " + subCommand.getCommand(subCommand.getClass()).name());
        super.registerSub(subCommand);
    }

    public PetCore getPlugin() {
        return this.plugin;
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        if (ConfigOption.INSTANCE.SIMPLER_GUI.getValue().booleanValue() && sender instanceof Player && args.length == 0) {
            ((Player)sender).performCommand("pet gui");
            return;
        }
        ArrayList adminCommands = Lists.newArrayList();
        this.getSubCommands().forEach(sub -> {
            if (sub.getClass().isAnnotationPresent(Permission.class)) {
                Permission permission = sub.getClass().getAnnotation(Permission.class);
                if (permission.adminCommand() && sender.hasPermission(permission.permission())) {
                    adminCommands.add(sub);
                    return;
                }
                if (!permission.defaultAllow() && !sender.hasPermission(permission.permission())) {
                    return;
                }
            }
            sub.sendUsage(sender);
        });
        if (adminCommands.isEmpty()) {
            return;
        }
        sender.sendMessage(ChatColor.RESET.toString());
        sender.sendMessage(Colorize.translateBungeeHex("&r &r &#e1eb5b[] &#d1c9c9----- &#b35349&lADMIN COMMANDS&r&#d1c9c9 ----- &#e1eb5b[]"));
        adminCommands.forEach(petSubCommand -> petSubCommand.sendUsage(sender));
    }
}

