/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api.wrappers.villager;

import org.bukkit.Material;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;

public enum BiomeType {
    DESERT(new ItemBuilder(Material.SAND)),
    JUNGLE(new ItemBuilder(Material.VINE)),
    PLAINS(new ItemBuilder(Material.GRASS_BLOCK)),
    SAVANNA(new ItemBuilder(Material.ACACIA_LOG)),
    SNOW(new ItemBuilder(Material.SNOW_BLOCK)),
    SWAMP(new ItemBuilder(Material.SLIME_BLOCK)),
    TAIGA(new ItemBuilder(Material.PODZOL));

    private final ItemBuilder icon;

    private BiomeType(ItemBuilder icon) {
        this.icon = icon;
    }

    public ItemBuilder getIcon() {
        return this.icon;
    }

    public static BiomeType getByName(String name) {
        for (BiomeType wrapper : BiomeType.values()) {
            if (!wrapper.name().equalsIgnoreCase(name)) continue;
            return wrapper;
        }
        return DESERT;
    }

    public static BiomeType getPrevious(BiomeType current) {
        if (current == DESERT) {
            return TAIGA;
        }
        return BiomeType.values()[current.ordinal() - 1];
    }

    public static BiomeType getNext(BiomeType current) {
        if (current == TAIGA) {
            return DESERT;
        }
        return BiomeType.values()[current.ordinal() + 1];
    }
}

