/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api.wrappers.horse;

import org.bukkit.entity.Horse;
import simplepets.brainsynder.api.wrappers.horse.HorseColorType;

public enum HorseStyleType {
    NONE(0, Horse.Style.NONE, new Integer[]{0, 1, 2, 3, 4, 5, 6}),
    WHITE(1, Horse.Style.WHITE, new Integer[]{256, 257, 258, 259, 260, 261, 262}),
    WHITEFIELD(2, Horse.Style.WHITEFIELD, new Integer[]{512, 513, 514, 515, 516, 517, 518}),
    WHITE_DOTS(3, Horse.Style.WHITE_DOTS, new Integer[]{768, 769, 770, 771, 772, 773, 774}),
    BLACK_DOTS(4, Horse.Style.BLACK_DOTS, new Integer[]{1024, 1025, 1026, 1027, 1028, 1029, 1030});

    private final HorseColorType[] a = new HorseColorType[]{HorseColorType.WHITE, HorseColorType.CREAMY, HorseColorType.CHESTNUT, HorseColorType.BROWN, HorseColorType.BLACK, HorseColorType.GRAY, HorseColorType.DARKBROWN};
    private final Integer[] b;
    private final Horse.Style bukkitStyle;
    private final int id;

    private HorseStyleType(int id, Horse.Style bukkitStyle, Integer[] i) {
        this.bukkitStyle = bukkitStyle;
        this.b = i;
        this.id = id;
    }

    public static HorseStyleType getByName(String name) {
        for (HorseStyleType wrapper : HorseStyleType.values()) {
            if (!wrapper.name().equalsIgnoreCase(name)) continue;
            return wrapper;
        }
        return NONE;
    }

    public static HorseStyleType getForBukkitStyle(Horse.Style style) {
        HorseStyleType[] arr$;
        for (HorseStyleType v : arr$ = HorseStyleType.values()) {
            if (!v.getBukkitStyle().equals((Object)style)) continue;
            return v;
        }
        return null;
    }

    public static HorseStyleType getByID(int id) {
        for (HorseStyleType v : HorseStyleType.values()) {
            if (v.getId() != id) continue;
            return v;
        }
        return null;
    }

    public int getId(HorseColorType v) {
        for (int i = 0; i < HorseColorType.values().length; ++i) {
            if (this.a[i] != v) continue;
            return this.b[i];
        }
        return -1;
    }

    public static HorseStyleType getPrevious(HorseStyleType current) {
        return current == NONE ? BLACK_DOTS : HorseStyleType.values()[current.ordinal() - 1];
    }

    public static HorseStyleType getNext(HorseStyleType current) {
        return current == BLACK_DOTS ? NONE : HorseStyleType.values()[current.ordinal() + 1];
    }

    public Horse.Style getBukkitStyle() {
        return this.bukkitStyle;
    }

    public int getId() {
        return this.id;
    }
}

