/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api.wrappers;

public enum PufferState {
    SMALL,
    MEDIUM,
    LARGE;


    public static PufferState getByID(int id) {
        for (PufferState v : PufferState.values()) {
            if (v.ordinal() != id) continue;
            return v;
        }
        return null;
    }

    public static PufferState getByName(String name) {
        for (PufferState wrapper : PufferState.values()) {
            if (!wrapper.name().equalsIgnoreCase(name)) continue;
            return wrapper;
        }
        return SMALL;
    }

    public static PufferState getPrevious(PufferState current) {
        PufferState target = SMALL;
        switch (current.ordinal()) {
            case 0: {
                target = LARGE;
                break;
            }
            case 1: {
                target = SMALL;
                break;
            }
            case 2: {
                target = MEDIUM;
            }
        }
        return target;
    }

    public static PufferState getNext(PufferState current) {
        PufferState target = SMALL;
        switch (current.ordinal()) {
            case 0: {
                target = MEDIUM;
                break;
            }
            case 1: {
                target = LARGE;
                break;
            }
            case 2: {
                target = SMALL;
            }
        }
        return target;
    }
}

