/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api.wrappers;

import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemType;

public enum NautilusArmorType {
    NONE("barrier"),
    COPPER("copper_nautilus_armor"),
    IRON("iron_nautilus_armor"),
    GOLD("golden_nautilus_armor"),
    DIAMOND("diamond_nautilus_armor"),
    NETHERITE("netherite_nautilus_armor");

    private final String rawMaterial;

    private NautilusArmorType(String rawMaterial) {
        this.rawMaterial = rawMaterial;
    }

    public NamespacedKey getKey() {
        return NamespacedKey.minecraft((String)this.rawMaterial);
    }

    public ItemType itemType() {
        return (ItemType)Registry.ITEM.get(this.getKey());
    }

    public static NautilusArmorType getByName(String name) {
        for (NautilusArmorType wrapper : NautilusArmorType.values()) {
            if (!wrapper.name().equalsIgnoreCase(name)) continue;
            return wrapper;
        }
        return NONE;
    }

    public static NautilusArmorType fromId(int id) {
        for (NautilusArmorType armor : NautilusArmorType.values()) {
            if (armor.ordinal() != id) continue;
            return armor;
        }
        return null;
    }

    public static NautilusArmorType getPrevious(NautilusArmorType current) {
        return current == NONE ? NETHERITE : NautilusArmorType.values()[current.ordinal() - 1];
    }

    public static NautilusArmorType getNext(NautilusArmorType current) {
        return current == NETHERITE ? NONE : NautilusArmorType.values()[current.ordinal() + 1];
    }
}

