/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api.user;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import simplepets.brainsynder.api.entity.IEntityPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;

public interface PetUser {
    public UUID getOwnerUUID();

    public String getOwnerName();

    public Player getPlayer();

    default public Optional<Location> getUserLocation() {
        if (this.getPlayer() instanceof Player) {
            return Optional.of(this.getPlayer().getLocation());
        }
        return Optional.empty();
    }

    public boolean hasPetSave(StorageTagCompound var1);

    public void removePetSave(StorageTagCompound var1);

    default public void addPetSave(IEntityPet entity) {
        if (entity == null) {
            return;
        }
        this.addPetSave(entity.asCompound());
    }

    public boolean canSaveMorePets();

    public boolean summonCachedPets();

    public void cacheAndRemove();

    public void addPetSave(StorageTagCompound var1);

    public List<Entry<PetType, StorageTagCompound>> getSavedPets();

    public List<PetType> getOwnedPets();

    public void addOwnedPet(PetType var1);

    public void removeOwnedPet(PetType var1);

    public Optional<String> getPetName(PetType var1);

    public void setPetName(String var1, PetType var2);

    public List<PetType> getHatPets();

    public boolean hasPets();

    public boolean hasPet(PetType var1);

    public boolean removePet(PetType var1);

    public boolean removePets();

    public Collection<IEntityPet> getPetEntities();

    public Optional<IEntityPet> getPetEntity(PetType var1);

    public void setPet(IEntityPet var1);

    public boolean hasPetHat();

    public boolean isPetHat(PetType var1);

    public void setPetHat(PetType var1, boolean var2);

    public boolean hasPetVehicle();

    public boolean canSpawnMorePets();

    public boolean isPetVehicle(PetType var1);

    public boolean setPetVehicle(PetType var1, boolean var2);

    public void updateDataMenu();

    public void updateSelectionMenu();

    public static class Entry<K, V> {
        private final K key;
        private final V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

