/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api.plugin;

import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import simplepets.brainsynder.api.ISpawnUtil;
import simplepets.brainsynder.api.inventory.handler.GUIHandler;
import simplepets.brainsynder.api.inventory.handler.ItemHandler;
import simplepets.brainsynder.api.other.ParticleHandler;
import simplepets.brainsynder.api.pet.PetConfigManager;
import simplepets.brainsynder.api.plugin.IPetsPlugin;
import simplepets.brainsynder.api.plugin.utils.IPetUtilities;
import simplepets.brainsynder.api.user.UserManagement;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.debug.DebugLogger;
import simplepets.brainsynder.libs.bslib.files.YamlFile;
import simplepets.brainsynder.libs.bslib.utils.AdvString;

public final class SimplePets {
    public static final DebugLevel ADDON = new DebugLevel("ADDON", ChatColor.of((String)"#dde6ea"), ChatColor.of((String)"#a6f2d8"));
    private static IPetsPlugin PLUGIN;

    public static void setPLUGIN(IPetsPlugin plugin) {
        if (PLUGIN != null) {
            return;
        }
        PLUGIN = plugin;
    }

    public static IPetsPlugin getPlugin() {
        if (PLUGIN == null || !SimplePets.class.getPackage().getName().startsWith("simplepets.brainsynder.api.plugin")) {
            PluginDescriptionFile pdf = SimplePets.getCause();
            Object baseMessage = "The SimplePets API was shaded into another plugin when it shouldn't be ";
            if (pdf != null) {
                baseMessage = (String)baseMessage + "(plugin: " + pdf.getName();
                StringBuilder builder = new StringBuilder();
                pdf.getAuthors().forEach(author -> builder.append((String)author).append(", "));
                baseMessage = builder.length() != 0 ? (String)baseMessage + " - by: " + AdvString.replaceLast(", ", "", builder.toString()) + ")" : (String)baseMessage + ")";
            } else {
                baseMessage = (String)baseMessage + "(Unable to pinpoint what plugin)";
            }
            throw new SecurityException((String)baseMessage);
        }
        if (!PLUGIN.hasFullyStarted() && !PLUGIN.isStarting()) {
            throw new IllegalStateException("The plugin (SimplePets) has not enabled successfully, please check your server logs whilst starting for more information.");
        }
        return PLUGIN;
    }

    private static PluginDescriptionFile getCause() {
        HashMap<String, PluginDescriptionFile> map = new HashMap<String, PluginDescriptionFile>();
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            PluginDescriptionFile pdf = plugin.getDescription();
            map.put(pdf.getMain(), pdf);
        }
        try {
            throw new Exception("Fetching location");
        }
        catch (Exception exception) {
            for (StackTraceElement element : exception.getStackTrace()) {
                String name = element.getClassName();
                if (name == null || name.contains("Thread") || name.startsWith(SimplePets.class.getPackage().getName())) continue;
                for (Map.Entry entry : map.entrySet()) {
                    if (!name.toLowerCase().contains(AdvString.beforeLast(".", (String)entry.getKey()).toLowerCase())) continue;
                    return (PluginDescriptionFile)entry.getValue();
                }
            }
            return null;
        }
    }

    public static YamlFile getConfiguration() {
        return SimplePets.getPlugin().getConfiguration();
    }

    public static UserManagement getUserManager() {
        return SimplePets.getPlugin().getUserManager();
    }

    public static IPetUtilities getPetUtilities() {
        return SimplePets.getPlugin().getPetUtilities();
    }

    public static ISpawnUtil getSpawnUtil() {
        return SimplePets.getPlugin().getSpawnUtil();
    }

    public static PetConfigManager getPetConfigManager() {
        return SimplePets.getPlugin().getPetConfigManager();
    }

    public static ItemHandler getItemHandler() {
        return SimplePets.getPlugin().getItemHandler();
    }

    public static GUIHandler getGUIHandler() {
        return SimplePets.getPlugin().getGUIHandler();
    }

    public static ParticleHandler getParticleHandler() {
        return SimplePets.getPlugin().getParticleHandler();
    }

    public static DebugLogger getDebugLogger() {
        return SimplePets.getPlugin().getDebugLogger();
    }

    public static boolean isPetEntity(Entity entity) {
        return SimplePets.getPlugin().isPetEntity(entity);
    }
}

