/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api.pet;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import simplepets.brainsynder.api.Namespace;
import simplepets.brainsynder.api.entity.IEntityPet;
import simplepets.brainsynder.api.pet.IPetConfig;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.json.JsonValue;

public abstract class PetData<EntityParam extends IEntityPet> {
    private final Map<String, ItemBuilder> defaultItems = new HashMap<String, ItemBuilder>();

    public Namespace getNamespace() {
        if (this.getClass().isAnnotationPresent(Namespace.class)) {
            return this.getClass().getAnnotation(Namespace.class);
        }
        throw new NullPointerException(this.getClass().getSimpleName() + " is missing @Namespace");
    }

    @Deprecated
    public abstract Object getDefaultValue();

    public Optional<Object> getDefault(PetType type) {
        IPetConfig config;
        JsonObject json;
        Optional<IPetConfig> optional = SimplePets.getPetConfigManager().getPetConfig(type);
        Namespace namespace = this.getNamespace();
        if (optional.isPresent() && (json = (config = optional.get()).getRawData(namespace.namespace())).names().contains("default")) {
            JsonValue value = json.get("default");
            if (value.isBoolean()) {
                return Optional.of(value.asBoolean());
            }
            if (value.isNumber()) {
                return Optional.of(value.asInt());
            }
            if (value.isString()) {
                return Optional.of(value.asString());
            }
        }
        return Optional.empty();
    }

    public Map<String, ItemBuilder> getDefaultItems() {
        return this.defaultItems;
    }

    public boolean isEnabled(EntityParam entity) {
        Optional<IPetConfig> optional = SimplePets.getPetConfigManager().getPetConfig(entity.getPetType());
        Namespace namespace = this.getNamespace();
        return optional.map(config -> config.getRawData(namespace.namespace()).getBoolean("enabled", true)).orElse(true);
    }

    public Optional<ItemBuilder> getItem(EntityParam entity) {
        Optional<IPetConfig> optional = SimplePets.getPetConfigManager().getPetConfig(entity.getPetType());
        Namespace namespace = this.getNamespace();
        String value = String.valueOf(this.value(entity));
        if (!optional.isPresent()) {
            if (this.defaultItems.containsKey(value)) {
                return Optional.of(this.defaultItems.get(value));
            }
            SimplePets.getDebugLogger().debug(DebugLevel.ERROR, this.getClass().getSimpleName() + " had no default item for '" + value + "'");
            return Optional.empty();
        }
        IPetConfig config = optional.get();
        if (this.defaultItems.containsKey(value)) {
            return config.getDataItem(namespace.namespace(), value, this.defaultItems.get(value));
        }
        return config.getDataItem(namespace.namespace(), value);
    }

    public void addDefaultItem(String value, ItemBuilder builder) {
        this.defaultItems.put(value, builder);
    }

    public abstract void onLeftClick(EntityParam var1);

    public void onRightClick(EntityParam entity) {
        this.onLeftClick(entity);
    }

    public abstract Object value(EntityParam var1);

    public boolean isModifiable(EntityParam entity) {
        return true;
    }
}

