/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api.inventory;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import simplepets.brainsynder.api.inventory.Item;
import simplepets.brainsynder.api.inventory.handler.InventoryType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.libs.bslib.files.JsonFile;
import simplepets.brainsynder.libs.bslib.json.JsonArray;
import simplepets.brainsynder.libs.bslib.json.JsonObject;

public abstract class CustomInventory
extends JsonFile {
    private int size = 0;
    private String title;
    private boolean enabled = true;
    protected Map<String, Integer> pageSave = new HashMap<String, Integer>();
    private final Map<Integer, Item> slots = new HashMap<Integer, Item>();

    public CustomInventory(File file) {
        super(file);
    }

    public void reset(PetUser owner) {
        if (owner == null) {
            return;
        }
        Player player = owner.getPlayer();
        if (player == null) {
            player = Bukkit.getPlayer((UUID)owner.getOwnerUUID());
        }
        if (player == null) {
            return;
        }
        this.pageSave.remove(player.getName());
    }

    @Override
    public void loadDefaults() {
        if (this.hasKey("enabled")) {
            this.enabled = this.getBoolean("enabled");
        }
        this.title = this.getString("title");
        this.size = this.getInteger("size");
        JsonArray slots = (JsonArray)this.getValue("slots");
        slots.forEach(jsonValue -> {
            JsonObject json = (JsonObject)jsonValue;
            try {
                int slot = json.getInt("slot", -1);
                String namespace = json.getString("item", "-unknown-");
                if (slot == 0) {
                    SimplePets.getDebugLogger().debug(DebugLevel.ERROR, "Slot can not be 0 for item '" + namespace + "'");
                    return;
                }
                if (slot == -1) {
                    SimplePets.getDebugLogger().debug(DebugLevel.ERROR, "Invalid slot for item '" + namespace + "'");
                    return;
                }
                if (namespace.equalsIgnoreCase("-unknown-")) {
                    SimplePets.getDebugLogger().debug(DebugLevel.ERROR, "Invalid item for slot '" + slot + "'");
                    return;
                }
                SimplePets.getItemHandler().getItem(namespace).ifPresent(item -> this.slots.put(slot - 1, (Item)item));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
    }

    public abstract void onClick(int var1, ItemStack var2, Player var3);

    public int getCurrentPage(PetUser user) {
        return this.pageSave.getOrDefault(user.getPlayer().getName(), 1);
    }

    public Map<Integer, Item> getSlots() {
        if (this.slots == null || this.slots.isEmpty()) {
            JsonArray slots = (JsonArray)this.getValue("slots");
            slots.forEach(jsonValue -> {
                JsonObject json = (JsonObject)jsonValue;
                try {
                    int slot = json.getInt("slot", -1);
                    String namespace = json.getString("item", "-unknown-");
                    if (slot == 0) {
                        SimplePets.getDebugLogger().debug(DebugLevel.ERROR, "Slot can not be 0 for item '" + namespace + "'");
                        return;
                    }
                    if (slot == -1) {
                        SimplePets.getDebugLogger().debug(DebugLevel.ERROR, "Invalid slot for item '" + namespace + "'");
                        return;
                    }
                    if (namespace.equalsIgnoreCase("-unknown-")) {
                        SimplePets.getDebugLogger().debug(DebugLevel.ERROR, "Invalid item for slot '" + slot + "'");
                        return;
                    }
                    SimplePets.getItemHandler().getItem(namespace).ifPresent(item -> this.slots.put(slot - 1, (Item)item));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
        }
        return this.slots;
    }

    public abstract InventoryType getInventoryType();

    public int getSize() {
        return this.getInteger("size", 9);
    }

    public String getTitle() {
        return this.getString("title", "UNKNOWN");
    }

    public void open(PetUser user) {
        this.open(user, 1);
    }

    public void open(PetUser user, int page) {
    }

    public void update(PetUser user) {
    }

    public boolean isEnabled() {
        return this.getBoolean("enabled", true);
    }
}

