/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.addon;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import simplepets.brainsynder.addon.PermissionData;
import simplepets.brainsynder.addon.PetModule;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.debug.DebugLevel;

public class AddonPermissions {
    private static final DebugLevel REGISTER;
    private static final Map<String, List<PermissionData>> permissions;
    private static final Map<String, Map<PermissionData, List<PermissionData>>> parentPermissions;

    public static boolean hasPermission(PetModule addon, CommandSender sender, String permission) {
        if (sender.isOp()) {
            return true;
        }
        String name = addon.getNamespace().namespace();
        Map map = parentPermissions.getOrDefault(name, new HashMap());
        for (Map.Entry entry : map.entrySet()) {
            for (PermissionData data : (List)entry.getValue()) {
                if (!data.getPermission().equalsIgnoreCase(permission) || !sender.hasPermission(((PermissionData)entry.getKey()).getPermission())) continue;
                return true;
            }
        }
        return sender.hasPermission(permission);
    }

    public static void register(PetModule addon, PermissionData data) {
        Objects.requireNonNull(addon);
        Objects.requireNonNull(data);
        String name = addon.getNamespace().namespace();
        List list = permissions.getOrDefault(name, new ArrayList());
        if (list.contains(data)) {
            return;
        }
        list.add(data);
        permissions.put(addon.getNamespace().namespace(), list);
        SimplePets.getDebugLogger().debug(REGISTER, "Registering '" + data.getPermission() + "' permission for the '" + addon.getNamespace().namespace() + "' addon");
    }

    public static void register(PetModule addon, PermissionData parentPermission, PermissionData data) {
        Objects.requireNonNull(addon);
        Objects.requireNonNull(parentPermission);
        Objects.requireNonNull(data);
        String name = addon.getNamespace().namespace();
        Map map = parentPermissions.getOrDefault(name, new HashMap());
        List children = map.getOrDefault(parentPermission, new ArrayList());
        if (children.isEmpty()) {
            SimplePets.getDebugLogger().debug(REGISTER, "Registering '" + parentPermission.getPermission() + "' permission and its children permissions for the '" + addon.getNamespace().namespace() + "' addon");
        }
        if (!children.contains(data)) {
            children.add(data);
            map.put(parentPermission, children);
            parentPermissions.put(name, map);
        }
    }

    public static Map<String, List<PermissionData>> getPermissions() {
        return permissions;
    }

    public static Map<String, Map<PermissionData, List<PermissionData>>> getParentPermissions() {
        return parentPermissions;
    }

    static {
        permissions = Maps.newHashMap();
        parentPermissions = Maps.newHashMap();
        REGISTER = new DebugLevel("Permissions", ChatColor.GRAY, ChatColor.GREEN);
    }

    public static enum AllowType {
        NONE("false"),
        DEFAULT("true"),
        OP("op");

        private final String allow;

        private AllowType(String allow) {
            this.allow = allow;
        }

        public String toString() {
            return this.allow;
        }
    }
}

